# -*- coding:utf-8 -*-
from datetime import timedelta
from celery.schedules import crontab

KEFU_PERSION_ID = 'a3c1087a1bdd11e682b70242c0a8020b'
DORIS_URL = 'redis://redis.paas-test.env/1'
LBS_REDIS_URL = 'redis://redis.paas-test.env:6379/0'
QUESTION_SCORE_WEIGHT = {
    'time_score_weight': 1,  #
    'answers_num_score_weight': 1,
    'answer_views_score_weight': 1,
    'answer_likes_score_weight': 1,
    'question_view_score_weight': 1,
    'question_answer_likes_score_weight': 1,
}

ALLOWED_HOSEPT_BLACK_LIST = [
    '00000000-0000-0000-0000-000000000000',
]

LIVE_REDIS = {'host': 'redis.paas-test.env', 'port': 6379, 'db': 4}

SECRET_KEY = 'fl-lv3j^czg(dupo@hbs(+_+djby9zelwt&rh71@b1x*ptmj4#(^'  # dev
DEBUG = True
TEMPLATE_DEBUG = True
RAVEN_CONFIG = {
    'dsn': 'dsn-service',
}
SITE_ID = 1
USE_DOC = False
TEMPLATES = []
GIFT_LOWER_LIMIT = 10000
GAME_WISHTREE_COUPON_ID = 1196
DORIS_DB_NAME = 'doris'
ARTEMIS_DB_NAME = "artemis"
POSEIDON_DB_NAME = "poseidon"

DJ_ORM_POOL_OPTIONS = {
    "pool_size": 20,
    "max_overflow": 0,
    "recycle": 3600,  # the default value
}
POOL_PESSIMISTIC_MODE = True

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.mysql',  # 设置为mysql数据库
        'NAME': 'zhengxing',  # zhengxing_test  test-zhengxing_for_ascle2
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': '172.18.52.35',
        'PORT': '',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",  # 为了支持emoji表情
        },
    },
    'slave': {
        'ENGINE': 'django.db.backends.mysql',
        'NAME': 'zhengxing',  # zhengxing_test
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        # 'HOST': '127.0.0.1',
        'HOST': '172.18.52.35',
        'PORT': '3306',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",
        },
    },
    'large_record': {
        'ENGINE': 'django.db.backends.mysql',  # 设置为mysql数据库
        'NAME': 'zhengxing',
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': '172.18.52.35',
        'PORT': '',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",  # 为了支持emoji表情
        },
    },
    'hera_test': {
        'ENGINE': 'django.db.backends.mysql',  # 设置为mysql数据库
        'NAME': 'hera_test',
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': '172.18.52.35',
        'PORT': '',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",  # 为了支持emoji表情
        },
    },
    'diagnosis': {
        'ENGINE': 'django.db.backends.mysql',  # 设置为mysql数据库
        'NAME': 'diagnosis',
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': '172.18.52.35',
        'PORT': '',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",  # 为了支持emoji表情
        },
    },
    'verita': {
        'ENGINE': 'django.db.backends.mysql',
        'NAME': 'verita_test',
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': '172.18.52.35',
        'PORT': '3306',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",
        },
    },
    'mimas': {
        'ENGINE': 'django.db.backends.mysql',
        'NAME': 'mimas_prod',
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': '172.18.52.35',
        'PORT': '3306',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",
        },
    },
    'doris': {
        'ENGINE': 'django.db.backends.mysql',  # 设置为mysql数据库
        'NAME': 'doris_prod',
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': '172.18.52.35',
        'PORT': '3306',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",  # 为了支持emoji表情
        },
    },
    'bran': {
        'ENGINE': 'django.db.backends.mysql',  # 设置为mysql数据库
        'NAME': 'bran_test',
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': '172.18.52.35',
        'PORT': '3306',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",  # 为了支持emoji表情
        },
    },
    'message': {
        'ENGINE': 'django.db.backends.mysql',
        'NAME': 'whisper',
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': '172.18.52.35',
        'PORT': '3306',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",
        },
    },
    'tidb': {
        'ENGINE': 'django.db.backends.mysql',  # 设置为mysql数据库
        'NAME': 'zhengxing',  # zhengxing_test  test-zhengxing_for_ascle2
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': '172.18.52.35',
        'PORT': '',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",  # 为了支持emoji表情
        },
    },
    'artemis': {
        'ENGINE': 'django.db.backends.mysql',
        'NAME': 'artemis_hotfix2',
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': '172.18.52.35',
        'PORT': '3306',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",
        },
    },
    'poseidon': {
        'ENGINE': 'django.db.backends.mysql',  # 设置为mysql数据库
        'NAME': 'poseidon_test_v2',
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': '172.18.52.35',
        'PORT': '3306',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",  # 为了支持emoji表情
        },
    },
    'jerry_tidb': {
        'ENGINE': 'django.db.backends.mysql',  # 设置为mysql数据库
        'NAME': 'jerry_test_v2',  # zhengxing_test  test-zhengxing_for_ascle2
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': '172.18.52.35',
        'PORT': '',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",  # 为了支持emoji表情
        },
    },

}
SLAVE_DB_NAME = 'slave'
HERA_READ_DB = 'slave'
MIMAS_SLAVE_DB_NAME = 'mimas'
MESSAGE_SLAVE_DB_NAME = 'message'
MESSAGE_HERA_SLAVE_DB_NAME = 'message'
DIAGNOSIS_SLAVE_DB_NAME = 'diagnosis'
LARGE_RECORD_DB_NAME = 'large_record'

PIMS_HOST = "psql-service"
PIMS_PORT = 5432
PIMS_DATABASE = "pims_test_v2"
PINS_NAME = "dbadmin"
PIMS_PASSWORD = "BJQaT9VzDcuPBqhg"

# ====================================================================================================
# =====================================GAIA_AUTHENTICATION============================================
# ====================================================================================================
GAIA_AUTHENTICATION = {
    'CHECK_MODE': 'PERMISSIVE',
    'SERVER_KEYS': [
        'basic:334+LrHY+Wh4IREkC4xjQcJ6fpIwlsH6HR8MKFVEH5LiyvqYq4QocqoNS7lcx23RO4v2FcB6YYoxMoEJhYoYpQ==',
        # pengfei, for ship
        'basic:c3AUKzE4iaGc5SBtkm3zMbjepw+vn7VHr/5fXaupEAo/HBeeVk6w+4EWEubwF1K9j6KSckd17hpBpQkNr9+uoA==',
        # chuncheng, for op_back
        'basic:M21gQkp0vWmDxlB5wVsIGCgbjdcshCsYaTgl4Rq0E6ug6Ma2teM9tpGCf5TZHsCGGC4cGQ4as9N3KmrDPQ43gA==',
        # pengfei, for wanmei_backend
        'basic:ZXhlV5AFrx7jy7vfwCFiANBlJyVK2kHfiZDVkeKlRkxjOlUb1euhRCbazG2aPdHkMNn8a+D/vqdZSYCj9qhpig==',
        # pengfei, for flag-ship
    ],
}

# ====================================================================================================
# ============================================REDIS===================================================
# ====================================================================================================
# BROKER_URL = 'redis://test-redis:6379/13'
BROKER_URL = 'redis://redis.paas-test.env/13'
BROKER_TRANSPORT_OPTIONS = {'visibility_timeout': 60 * 60 * 24 * 3}  # 3days. Make sure that colleagues have knew that
REDIS = {
    'doctor': {'host': 'redis.paas-test.env', 'port': 6379, 'db': 0},
    'hospital': {'host': 'redis.paas-test.env', 'port': 6379, 'db': 1},
    'view': {'host': 'redis.paas-test.env', 'port': 6379, 'db': 2},
    'user_cache': {'host': 'redis.paas-test.env', 'port': 6379, 'db': 5},
    'conversation_cache': {'host': 'redis.paas-test.env', 'port': 6379, 'db': 6},
    'tag_cache': {'host': 'redis.paas-test.env', 'port': 6379, 'db': 12},
    'diary': {'host': 'redis.paas-test.env', 'port': 6379, 'db': 4},
    'page_cache': {'host': 'redis.paas-test.env', 'port': 6379, 'db': 15},
    'coupon_gift': {'host': 'redis.paas-test.env', 'port': 6379, 'db': 10},
    'social_cache': {'host': 'redis.paas-test.env', 'port': 6379, 'db': 11},
    'vote_cache': {'host': 'redis.paas-test.env', 'port': 6379, 'db': 11},
    'wechat': {'host': 'redis.paas-test.env', 'port': 6379, 'db': 11},
    'game': {'host': 'redis.paas-test.env', 'port': 6379, 'db': 4},
    'resys_cache': {'host': 'redis.paas-test.env', 'port': 6379, 'db': 3},
    'user_reg_lock': {'host': 'redis.paas-test.env', 'port': 6379, 'db': 14},
    'black_name': {'host': 'redis.paas-test.env', 'port': 6379, 'db': 0},
    'wechat_token_lock': {'host': 'redis.paas-test.env', 'port': '6379', 'db': 4},
    'sku_stock_lock': {'host': 'redis.paas-test.env', 'port': 6379, 'db': 6},
    'bdtransfer_record': {'host': 'redis.paas-test.env', 'port': 6379, 'db': 0},
}

REDIS_BLACK_IP_PREFIX = "test_cpc_block_ip:"
REDIS_BLACK_DEVICE_PREFIX = "test_cpc_block_device_id:"

# DEFAULT_REDIS = {'host': 'test-redis', 'port': 6379, 'db': 14}
DEFAULT_REDIS = {'host': 'redis.paas-test.env', 'port': 6379, 'db': 14}

# ====================================================================================================
# ============================================极光推送=================================================
# ====================================================================================================
BIG_PUSH_DURATION = 1
PUSH_STAT_DELAY = 60
USER_JPUSH_APP_KEY = "9e779399e200529a63722da7"
USER_JPUSH_MASTER_SECRET = "38a0a35dc8bc96b509fc61e1"
DOCTOR_JPUSH_APP_KEY = "5c450e73f736580543d0bd4e"
DOCTOR_JPUSH_MASTER_SECRET = "688b209acae48381ece1f3f8"
JPUSH_IOS_OPTIONS = {
    "apns_production": False,
}
IPHONE_USE_SANDBOX = True

# ====================================================================================================
# ============================================ES======================================================
# ====================================================================================================
ES_HOSTS = [{'host': '127.0.0.1', 'port': 9200}]
ES_V2_HOSTS = [
    {'host': '127.0.0.1', 'port': 9200},
]
TALOS_ES_HOSTS = [
    {'host': '127.0.0.1', 'port': 9200},
]
ES_INDEX_PREFIX = 'gm_test'
ES_READ_INDEX = 'gm_test_read'
ES_WRITE_INDEX = 'gm_test_write'
ES_CONSTS = {
    'TAG_ID_DIRECTOR_RECOMMEND': 1142,  # "所长精选" tag id
    'TAG_ID_POPULAR': 1202,  # "热门讨论" tag id
    'TAG_ID_POPULAR_RECOMMEND': 1203,  # "热门推荐" tag id
    'TAG_ID_DIARY_WITH_SERVICE': 1144,  # "美购日记" tag id
}
# 私信 ES
# ES_MSG_HOSTS = [{'host': 'dev-es', 'port': 9200}]
# ES_MSG_READ_INDEX = 'gm_msg_test_read'
# ES_MSG_WRITE_INDEX = 'gm_msg_test_write'
ES_MSG = {
    'order': ['db2'],
    'database': [{
        'name': 'db1',
        'es_version': 'v1',
        'hosts': [{'host': '127.0.0.1', 'port': 9200}],
        'table': [{
            'name': 'conversation',
            'index': 'gm_msg_test',
            'doc_type': 'conversation',
        }, {
            'name': 'message',
            'index': 'gm_msg_test',
            'doc_type': 'message',
        }]
    }, {
        'name': 'db2',
        'es_version': 'v2',
        'hosts': [
            {'host': '127.0.0.1', 'port': 9200},
        ],
        'table': [{
            'name': 'conversation',
            'index': 'gm_msg_test-conversation',
            'doc_type': 'conversation',
        }, {
            'name': 'message',
            'index': 'gm_msg_test-message',
            'doc_type': 'message',
        }]
    }, {
        'name': 'db3',
        'es_version': 'v2',
        'hosts': [
            {'host': '127.0.0.1', 'port': 9200}
        ],
        'table': [{
            'name': 'conversation',
            'index': 'gm_msg_test-conversation',
            'doc_type': 'conversation',
        }, {
            'name': 'message',
            'index': 'gm_msg_test-message',
            'doc_type': 'message',
        }]
    }]
}

# ====================================================================================================
# ==========================================DATA SYNC=================================================
# ====================================================================================================
DATA_SYNC = {
    'redis_url': 'redis://redis.paas-test.env:6379/15',
    'prefix': 'gaia:data-sync',
    'enqueue_table_event': True,
    'table_event_process_delay_list': [],
    'fetch_chunk_size': 1,
}

# ====================================================================================================
# =========================================ASYNC_QUEUE================================================
# ====================================================================================================
ASYNC_QUEUE = {
    'redis_url': 'redis://redis.paas-test.env:6379/13',
    'redis_prefix': 'test-gaia:async-queue',
    'logger_name': 'async_queue_logger',
    'check_period_seconds': 1,
    'watchdog_min_timeout': 10 * 60,
    'watchdog_max_timeout': 10 * 60,
}

# ====================================================================================================
# ==========================================分期付款===================================================
# ====================================================================================================
JIKE_URL = "http://test.geexfinance.com/merchant/service"
JIKE_SERVICE_ID = "gengmei"
JIKE_SERVICE_HASH = "3710f84987aaa4f455a10f8bbb5c55e1"
JIKE_USERID = '12369'

# ====================================================================================================
# ==========================================短信======================================================
# ====================================================================================================
UCPAAS_SID = '1e180b53a6a0f901daf1b149e2a4f152'
UCPAAS_TOKEN = '8f754ea467f6d8a4036a220686876c05'
UCPAAS_APPID = 'cd723194f6ff458092118b52c5516079'
UCPAAS_SERVER_HOST = 'https://api.ucpaas.com'
UCPAAS_SERVER_PORT = ''
UCPAAS_VERSION = '2014-06-30'
UCPAAS_TEMPID = '10862'
SMS_MODEL = 'ucpaas'
ALIDAYU_HOST = u'http://gw.api.taobao.com/router/rest'
ALIDAYU_SECRET = u'aefbeb3a8d53d9c02c379bb1bed289e1'
ALIDAYU_APPKEY = u'23401193'
ALIDAYU_SIGNNAME = u'更美APP'
DEFAULT_SMS_PLATFORM = u'alidayu'
MD_HOST = u'http://sdk.entinfo.cn:8060/webservice.asmx/mt'
MD_SN = u'SDK-BBX-010-19243'
MD_PWD = u'E5D3CF92329CA75E6B794ADE37154616'

# ====================================================================================================
# ============================================微信====================================================
# ====================================================================================================
M_WECHAT_APP_ID = 'wx5dcbb1544163c77c'
M_WECHAT_PARTNER_ID = '1284132201'
M_WECHAT_SECRET = 'e821f46be6ee45e3ca80d189f989313b'  # 不是微信的SECRET 是 pay.weixin.qq.com!!
M_WECHAT_PEM_KEY = "/srv/secret/m_apiclient_key.pem"
M_WECHAT_PEM_CERT = "/srv/secret/m_apiclient_cert.pem"

WXAPP_WECHAT_APP_ID = 'wx113018c998de9eaf'
WXAPP_WECHAT_PARTNER_ID = '1284132201'
WXAPP_WECHAT_SECRET = 'e821f46be6ee45e3ca80d189f989313b'  # 不是微信的SECRET 是 pay.weixin.qq.com!!
WXAPP_WECHAT_PEM_KEY = "/srv/secret/wechatapp_apiclient_key.pem"
WXAPP_WECHAT_PEM_CERT = "/srv/secret/wechatapp_apiclient_cert.pem"

M_WECHAT_NOTIFY_URL = 'http://exchange.env.wanmeizhensuo.com/payment/pay/wechat/notify'

CLIENT_WECHAT_APP_ID = "wx403cd28c142c7d87"
CLIENT_WECHAT_PARTNER_ID = "1302548401"
CLIENT_WECHAT_SECRET = "e821f46be6ee45e3ca80d189f989313b"
# cert
CLIENT_WECHAT_PEM_KEY = "/srv/secret/client_apiclient_key.pem"
CLIENT_WECHAT_PEM_CERT = "/srv/secret/client_apiclient_cert.pem"

# 微信小程序
WECHAT_SMALL_APPID = 'wx113018c998de9eaf'
WECHAT_SMALL_APPSECRET = '328083f0cbb131c7de3b3920eed8ddaf'
# ====================================================================================================
# ============================================新微信====================================================
# ====================================================================================================

NEW_WECHAT_PID_LIST = ['1556230611', '1555124561']  # 区分新老账号退款

NEW_WXAPP_WECHAT_PARTNER_ID = '1556230611'
NEW_WXAPP_WECHAT_SECRET = 'hyJyxnyMjcmq2qwpycttz2vd5xknlwee'  # 不是微信的SECRET 是 pay.weixin.qq.com!!
NEW_WXAPP_WECHAT_PEM_KEY = '/srv/secret/wxpay/1556230611/apiclient_key.pem'
NEW_WXAPP_WECHAT_PEM_CERT = '/srv/secret/wxpay/1556230611/apiclient_cert.pem'

# GM_GATEWAY = 'http://dev.a.xxapi.cn'
GM_GATEWAY = 'http://exchange.env.wanmeizhensuo.com'

NEW_M_WECHAT_NOTIFY_URL = GM_GATEWAY + '/payment/wechat/callback'

NEW_CLIENT_WECHAT_PARTNER_ID = "1302548401"
NEW_CLIENT_WECHAT_SECRET = "e821f46be6ee45e3ca80d189f989313b"
# cert
NEW_CLIENT_WECHAT_PEM_KEY = "/srv/secret/client_apiclient_key.pem"
NEW_CLIENT_WECHAT_PEM_CERT = "/srv/secret/client_apiclient_cert.pem"

# ====================================================================================================
# ============================================支付宝===================================================
# ====================================================================================================
# TEST_CALLBACK_URL = 'http://exchange.env.wanmeizhensuo.com'
TEST_CALLBACK_URL = 'http://dev.a.xxapi.cn'

# 支付宝网关
ALIPAY_GATEWAY = "http://wappaygw.alipay.com/service/rest.htm"
# 合作身份者ID，以2088开头的16位纯数字
ALIPAY_PARTNER = '2088211612339882'
ALIPAY_SELLER_USER_ID = ALIPAY_PARTNER
# 请求参数格式
ALIPAY_FORMAT = 'xml'
# 支付宝接口版本号
ALIPAY_VERSION = "2.0"
# 签约支付宝账号或卖家支付宝帐户
ALIPAY_SELLER_EMAIL = 'zhengxuan@wanmeizhensuo.com'
# 交易过程中服务器通知的页面 要用 http://格式的完整路径，不允许加?id=123这类自定义参数
# ALIPAY_NOTIFY_URL = 'http://wanmeizhensuo.com/alipay_notify'
# ALIPAY_NOTIFY_URL = ''
# ALIPAY_NOTIFY_URL = 'http://exchange.env.wanmeizhensuo.com/paas/backend/api/order/purchase/xml/'
ALIPAY_NOTIFY_URL = 'http://exchange.env.wanmeizhensuo.com/payment/settlement/purchase/xml/'
# 付完款后跳转的页面 要用 http://格式的完整路径，不允许加?id=123这类自定义参数
# return_url的域名不能写成http://localhost/js_php_utf8/return_url.php ，否则会导致return_url执行无效
ALIPAY_CALLBACK_URL = ""
# 网站商品的展示地址，不允许加?id=123这类自定义参数
ALIPAY_SHOW_URL = 'http://wanmeizhensuo.com'
# 签名方式 不需修改
ALIPAY_SIGN_TYPE = 'MD5'
# 字符编码格式 目前支持 GBK 或 utf-8
ALIPAY_INPUT_CHARSET = 'utf-8'
# 访问模式,根据自己的服务器是否支持ssl访问，若支持请选择https；若不支持请选择http
ALIPAY_TRANSPORT = 'http'
# MD5 密钥
ALIPAY_MD5_KEY = "2894fddi6kahmpj56n008le81gjnvdwp"
ALIPAY_SERVICE_DIRECT_TRADE_CREATE = "alipay.wap.trade.create.direct"
ALIPAY_SERVICE_AUTH_EXECUTE = "alipay.wap.auth.authAndExecute"

ALIPAY_REFUND_NOTIFY_URL = 'http://exchange.env.wanmeizhensuo.com/payment/alipay/callback/refund'
ALIPAY_CASHBACK_NOTIFY_URL = 'http://exchange.env.wanmeizhensuo.com/payment/alipay/callback/cashback'
# ALIPAY_REFUND_NOTIFY_URL = TEST_CALLBACK_URL + '/api/alipay/callback/refund'
# ALIPAY_CASHBACK_NOTIFY_URL = TEST_CALLBACK_URL + '/api/alipay/callback/cashback'
# ===ALIPAY_APP_CONFIG===START
# https://doc.open.alipay.com/doc2/detail.htm?treeId=204&articleId=105465&docType=1
ALIPAY_APP_APP_ID = "2016051901420550"
ALIPAY_APP_SELLER_USER_ID = ALIPAY_SELLER_USER_ID
ALIPAY_APP_NOTIFY_URL = 'http://exchange.env.wanmeizhensuo.com/paas/backend/pay/alipay/notify'
ALIPAY_APP_TIMEOUT_EXPRESS = '30m'  # "30m" "12h" "3d" "1c" (???)
# 商家的私钥
ALIPAY_APP_MY_PRIVATE_KEY = """-----BEGIN PRIVATE KEY-----
MIICXwIBAAKBgQDkGyj52wT/zQuRa1mAKwAkq09JZDCGcoBc4iLUchNvyAC8KJLTNDRMI+hA8VCsQv4s+usgvQvfjNYq4/Ryoh7mQbrVrFBc38IfPhbmNbHsczTX5+ZR8/LKcA3yNcJYbbAleFuqR89kxxo93rtBLsP0lWUn1R76MV15BOKw5UiXlwIDAQABAoGBAN2x4/ZKPqaa02ZnLhpaMI5zDOEohdz1xfoAMpfFs0xN1yEIUgMBVt61e1I69wwlJEH1MLal5bdEexY+bONI27taE5AkWb2vF3PMjt3TeyJCrxtDtq78Vxk/oXQA/9DaPz0Fa0UbDgIZPZZGVLLol3VRg88x00dRK+cQvgZ1jjhRAkEA+tSct5C/7DziNbGKf/xfKHYzciEb75Y/JF6JDdhHTHh/sDFYRspQoyEfhAqHXygRB0kiGoURlNGz/hXECKF1qQJBAOjOpz3yHyT1o3T1aUTfIZA0zT486Bj8yhiULrYqOrISQqWWXXktDnwM1JhXGgxmtCtdywCkHuiRQDT/DBvHaz8CQQC2/c2njg62hmRxz6i/Xpr9pd46cTU0QWSnX+CVHShG/dIJ9LX2TzstB8k6R4QjQ9PIgO5Ecrg03hh2UeLGeSShAkEAhYYg/bJkknogKfCnU8z2HxNptAySweIat0YmFGzcBU3b08UOD3X8HMHvHQC3++zb4ROGXvPClnjYbozpkPUrWQJBAMBZoVZtntWxD3akZBbBO9dfXktrlxagvWNWtSPnDfDsdn+qRRQr6ln4TBkLk/nDYQSiLtFzBxuyrrtCncfbcnc=
-----END PRIVATE KEY-----"""
# 支付宝针对商家的公钥
ALIPAY_APP_ALI_PUBLIC_KEY = """-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDDI6d306Q8fIfCOaTXyiUeJHkrIvYISRcc73s3vF1ZT7XN8RNPwJxo8pWaJMmvyTn9N4HQ632qJBVHf8sxHi/fEsraprwCtzvzQETrNRwVxLO5jVmRGi60j8Ue1efIlzPXV9je9mkjzOmdssymZkh2QhUrCmZYI/FCEa3/cNMW0QIDAQAB
-----END PUBLIC KEY-----"""

# 旧的回调地址
ALIPAY_APP_OLD_NOTIFY_URL = 'http://exchange.env.wanmeizhensuo.com/payment/alipay/callback'
# 旧的商家的私钥，在原有接口被废弃在之后可以删除相关的代码和这里的配置
ALIPAY_APP_OLD_MY_PRIVATE_KEY = """-----BEGIN PRIVATE KEY-----
MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBALY37P8VQobI+24mwEjDV/8aAPNnS9MXJW0ZC7fnWXajJOue4X7/L+qDaWpTj/cptpFLomsl6IKAxMSefBO0CGpkjI1Oe0G9tg+Ki4Szk7CdaYNfhhRpyFwOhKiGgEKSCmboinOkc8yuD02kdSfrhzOrmN2I2KVMBjFW7V8JczN/AgMBAAECgYEAk8If3OzJaHCbacPkklxNA+B7OuTdWIvhXmk71mG0av56FtJcOlYF7d2n4n9mM19Q2tsBFm/D7ecrJ+D37iZD11vZmmwIOl5/CwOf9MUwP3ENG7S1Ax/CIZaM5MuwUs4sLXgMKaImPXq4u7UWqVuxwH+iyokXxz/uxCMf+0qFPSkCQQDc7DNZhDqh1M2ZDqhliCSP/nn8CHX6BYRIEbMQW7g1V59TOr89N8ht3FZ5b3dVItielU4dRez7o4BPYThVL6udAkEA0yaF9/BYKg9LBAPJxvnNZWu1GmabpMmawx45B4jdoTLrK+wwGPwORBIyZ+og5M0IRTW5w42ECM/Fi+KAjU82ywJAJc/jphGku2gh3G2O0vnvUBn9JO8JykZBcthcrpMUP0UFBwjKDJ9Mlckdn+E9KnwxWUsyuH3sZtGAN5XrP2FOXQJAdlUIj0LqpeecKsvUsOYd7dDG1dzbLSauzNqLK2XQjx5yHVNoQRhBBnUMOqBDfvZIxECvsqAEdsu58gMl+AuEsQJAZ6r6GHJLyQEvz5RJ8KeYnAK0FxrH76gfCPE1luLf/DVifYIopfnBbB2TczbpxEwmC1K0fk3K6HdbQnpU5o67QQ==
-----END PRIVATE KEY-----"""
# 旧的支付宝针对商家的公钥，在原有接口被废弃在之后可以删除相关的代码和这里的配置
ALIPAY_APP_OLD_ALI_PUBLIC_KEY = """-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCnxj/9qwVfgoUh/y2W89L6BkRAFljhNhgPdyPuBV64bfQNN1PjbCzkIM6qRdKBoLPXmKKMiFYnkd6rAoprih3/PrQEB/VsW8OoM8fxn67UDYuyBTqA23MML9q1+ilIZwBC2AQ2UBVOrFXfFl75p6/B5KsiNG9zpgmLCUYuLkxpLQIDAQAB
-----END PUBLIC KEY-----"""

# ===ALIPAY_APP_CONFIG===END

MAIDAN_VISIBLE = True

# 买单的支付通知URL前缀，请保证最后一个字符是"/"
MAIDAN_PAY_NOTIFY_URL_BASE = "http://backend-service/pay/maidan/notify/"

# ------------------------------- 第三套支付宝商户信息 ------------------------------------
U_ALIPAY_APP_APP_ID = "2021001102610674"
U_ALIPAY_PARTNER = '2088631329506836'
U_ALIPAY_MD5_KEY = "aloc1am3hzlgw9eynx7uy8ccwxlffh7i"
# 支付宝公钥
U_ALIPAY_APP_ALI_PUBLIC_KEY = """-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo/Bz2nf8H/C+1/+Ic3z6WWnSimFpp+rTPTDk3X/k0f1M9elwhJU05Lq9/KLuFpEgLN6ntxIct7GAnootyVfSVEq4CQSwy54CyWRfaPYDtEFgIZR/7MLyxmlewYOFGfky1kHiA6L6EBrANxVDYFILPycz6vC9+5wqDGNs6BxnP3nUu7YGMg6apxzpcuygZc5DFsp4wyPLLPeYNDhizmv0daQvgjW8562fEDzS8Ncz1+Dn1PZvyuVp1brmsMGkHdzAKOHWqKJiIsVvjlgBiHMmJV5Hwl9Reubl1QHruhpa5Dj3RpZiNkdxC7mXbif/lny+IKLDjiVwlDiIuZ4QTdBMCQIDAQAB
-----END PUBLIC KEY-----"""

U_ALIPAY_APP_MY_PRIVATE_KEY = """-----BEGIN PRIVATE KEY-----
MIIEpAIBAAKCAQEA3XAFwYOxllHs7LGUSQxUJ/zyv76e8Fr4IL5zRact50J5WEwjuj7tfA8iJVknGAwFM3lYM1r4eQn/LsDG9S6v0PqiWA2KpfYdFqqvgG2YpGGog8z4JdGUY1hMYvwD4vx/cV2b7UWjZkaSXwzb2BHjZsZKohoWKYnlL0thFnFyDlATRjTYJsuk+Nzah8YDm6RZa37bK0Gj1kYEYAhoycU2yO0kE4TY3mJaWIm2sVMSuLtm27D2iPdpkjgpZWnuC6cFfXakwo0Ir8q4Z5TizLtafAoHQzHgk9GWejxz9bVkBR1c00/PvUxsW6CrDGvrVLQscfAJdqBYCYnahpyhnTO4JwIDAQABAoIBAQC04pBhHpHPqEawpvLppP+N1sv5I96zmqv8G3cQW9tcgOmc3j2FI2hdogMTnTsZIqCRBrus38//F9JzP5iGqkeGn2ZEJXOv1Fa4sF9CusQo63l7iNDgG85qRLPJW/JU1kvIsF3yOaObpWRl7pwbaalnx+0pc8PM1M75jkrVyYAQ/YUQW2lUIi9f5FqntZknZJdBIMM6rppZpVMW7ronMlJU9dR7w3ds8v4xGN0Dp7GOcJlD8frags5HG+xZI/rR3h8k3cnI9UP0lBPpYHZMm6Bxriu1rMywgvQ1M1Tzw0DeAI+P+SIo0W25ajf4MWh6FQrLWXo2+lEz2tjcVMlJktr5AoGBAPkHtap/R0amcJ+s1iW560ZThRTXrj1Mnt8nW8ej4nw0/X1aqxgUb/g07hMRxxFwrVFjGkjaU7P17RFuNXHsJ9MlIba2A6c8a9aQWrArW1ZrjPDONbFL/VLQDLiGOCM9R5Vc8TNMx9FMwcCzK9w3L7+pcdJYjegcvlRbd/FS3Bv1AoGBAOOinREbxcmVtd+lBQcBmu+TLUxVM9L9jI3uCMRfOS7xy3vF1+Mhb042YHF5B6oWWxVvWoD1lycyIj/Crcm4TuFOUZk6gA0y5B5R/KkrRE3t4juljXeZz+PkTGxGcfDYRy39KySGCeFEV6qlkCS2f3ixbHszQ0/1ACQSR25cQS4rAoGAQxvlw+2Kyqo9vXn5N69zjL8jJOu+g7xrL93OaO1sMmahTS+q3dFcHzo8Uh0/VR7VRhJ72dgkKGIEoebeNjYawVbHUBKax22L7gV2uvTkJ1TSZW5cn8vHl5KDaxKYfD6eVMz4Hwf47RlPOVvPXQfuMSs7hiDhFQTx8Y+4serPcCUCgYBIX/p6Zw8iwcPawJfxm1QMmgnL/EcG7XCT67vD29bNkzk0ODok0AuYnXdafLWwIX2COi5XVD5jyu/Sv+4Ldds2jXUqN8xg5e5bqYugqc4EzP6iIkfxX+kWNw8JWfh+L/WprJXb/fYENnt9GTjUQ2YSFK8+GJVtRaNu1JT7hL+AkwKBgQCcD8AcSDzvKXoKfOyczl0LkGCLgFpYj7/1jGXgvDiRt4Gfiy78XCH+2iawhRG+ZYZjnJCjjn3VTa2mP+JEMPBUl3S96uNT0EWxqriKmK4WvMhrswmhJcS40nslRmIZhsiM2FcK8DKPgyog6mSRq5GLOgcziWjhct3U6p/CX9o4LA==
-----END PRIVATE KEY-----"""

U_ALIPAY_NOTIFY_URL = GM_GATEWAY + '/payment/alipay/callback'
U_ALIPAY_REFUND_NOTIFY_URL = GM_GATEWAY + '/payment/alipay/callback/refund'
U_ALIPAY_CASHBACK_NOTIFY_URL = GM_GATEWAY + '/payment/alipay/callback/cashback'

# ====================================================================================================
# ============================================yinuo==============================================
# ====================================================================================================
YINUO_SECRECT = 'kwR58f2BNLWemSmOEDsi9mJReWpHfGo8'
YINUO_USER_ID = 'KOQ6CNWM'
YINUO_CREATE_URL = 'https://api-sandbox.yinuobaoxian.com/partner/order/create'
YINUO_PAY_URL = 'https://api-sandbox.yinuobaoxian.com/partner/order/pay-balance'
YINUO_PREMIUM = 5
YINUO_PRODUCT_ID = '8YMWI5QZ'
YINUO_PLAN = 'A'
# ====================================================================================================
# ============================================Apple Pay===============================================
# ====================================================================================================
APPLEPAY_MD5_KEY = 'v99#l2*hy4omRGqp$#c5OJJ77KOK6mz^'
OID_PARTNER = '201603031000747503'
APPLEPAY_PAY_NOTIFY_URL = 'http://exchange.env.wanmeizhensuo.com/paas/backend/pay/apple/notify'
APPLEPAY_REFUND_URL = 'https://traderapi.lianlianpay.com/refund.htm'
APPLEPAY_REFUND_NOTIFY_URL = 'http://exchange.env.wanmeizhensuo.com/paas/backend/pay/apple/callback/refund'

# ====================================================================================================
# ============================================360生活助手==============================================
# ====================================================================================================
LIFE_360_QID = "829439411"
LIFE_360_SECRET_KEY = "kGhkO9r5FrzHmLQG"
LIFE_360_GET_MOBILE_URL = "http://profile.sj.360.cn/live/get-mobile"

# ====================================================================================================
# ============================================新浪微博=================================================
# ====================================================================================================
SINA_WEIBO_GET_UID_URL = "https://api.weibo.com/oauth2/get_token_info"

INTERNAL_EMAIL = {
    'address': 'bot@wanmeizhensuo.com',
    'host': 'smtp.exmail.qq.com',
    'username': 'bot@wanmeizhensuo.com',
    'password': 'OJi17cLf1c84c9N1af37Jja0eCvx9BI6',
}

TEST_EMAIL_LIST = [
    'wangjiabin@igengmei.com',
    'bidan@igengmei.com',
    'sunwenhui@igengmei.com',
    'guojiahua@wanmeizhensuo.com',
    'xuepengfei@wanmeizhensuo.com',
    'maruitao@wanmeizhensuo.com',
    'wangyang@wanmeizhensuo.com',
    'chenxuemei@igengmei.com',
    'wangnan@wanmeizhensuo.com',
    'wangjinlong@wanmeizhensuo.com',
    'jiaoyang@wanmeizhensuo.com',
    'zhuyufeng@wanmeizhensuo.com',
    'yangchuncheng@wanmeizhensuo.com',
    'zhaojiajun@wanmeizhensuo.com',
    'wangnan@wanmeizhensuo.com',
    'qiaojinzhu@wanmeizhensuo.com',
    'yilingxiao@wanmeizhensuo.com',
    'renshuai@wanmeizhensuo.com',
    'wangjun1@igengmei.com',
    'zhangyunyu@wanmeizhensuo.com',
    'linli@wanmeizhensuo.com',
    'lizhenghao@igengmei.com',
    'zhongchengyang@igengmei.com',
    'zhaohuatian@igengmei.com',
    'zhengdixun@igengmei.com',
    'mayan@igengmei.com',
    'yangheng@igengmei.com',
    'louchaoqi@igengmei.com',
    'liuyu@igengmei.com',
    'wangzhuxi@igengmei.com',
    'xumingming@igengmei.com',
    'mayan@igengmei.com',
    'lizexia@igengmei.com',
    'zhangweinan@igengmei.com',
]

TEST_PHONE_EMAIL_MAP = {
    '13718228007': 'zhaiguojun@wanmeizhensuo.com',
    '18601965003': 'qiaojinzhu@wanmeizhensuo.com',
    '15711434789': 'licong@wanmeizhensuo.com',
    '15811315780': 'wangyang@wanmeizhensuo.com',
    '18742441012': 'zhangyunyu@wanmeizhensuo.com',
    '18363625622': 'zhaohuatian@igengmei.com',
    '13720079874': 'zhengdixun@igengmei.com',
    '13522130504': 'wangnan@igengmei.com',
    '18610951795': 'liumiaoqi@igengmei.com',
    '18701550109': 'liuhairu@igengmei.com',
    '13716255042': 'yangheng@igengmei.com',
    '18666826943': 'nijiahua@igengmei.com',
    '18363625622': 'zhaohuatian@igengmei.com',
    '15510492564': 'mayan@igengmei.com',
    '18337157587': 'lizexia@igengmei.com',
}

TEST_PHONE_LIST = [
    '13521626466',
    '1391300267',
    '13683061063',
    '18601965003',
    '18810225027',
    '18811149976',
    '18210132873',
    '18345378781',
    '15510789751',
    '18611450809',
    '15102273250',
    '18363625622',
    '13161047169',
    '15009286557',
    '13720079874',
    '18610951795',
    '13716255042',
    '18666826943',
    '18363625622',
    '18610811754',
    '+8201024494425',
    '15010139361',
    '18858517222'
]

ANONYMOUS_USER_ID = 19634221

# 统计邮件发送帐号
STATIS_EMAIL_USER = ''
STATIS_EMAIL_PSWD = ''

DOCTOR_REFUND_TIMEOUT_MINUTES = 5

__CELERYBEAT_SCHEDULE = {
    'sms_service': {
        'task': 'api.tasks.period_task.sms_service',
        'schedule': timedelta(seconds=1200),
        'args': ()
    },
    'link_doctor': {
        'task': 'api.tasks.period_task.link_doctor',
        'schedule': timedelta(minutes=6),
        'args': ()
    },
    'share_topic_add_point': {
        'task': 'api.tasks.period_task.share_topic_add_point',
        'schedule': timedelta(minutes=30),
        'args': ()
    },
    'hospital_body_sub_items': {
        'task': 'api.tasks.period_task.hospital_body_sub_items',
        'schedule': timedelta(days=1),
        'args': ()
    },
    'update_diary_last_modified': {
        'task': 'api.tasks.period_task.update_diary_last_modified',
        'schedule': timedelta(minutes=60),
        'args': ()
    },
    'hot_in_24hrs': {
        'task': 'api.tasks.period_task.hot_in_24hrs',
        'schedule': crontab(minute=0, hour='9,12,21'),
        'args': ()
    },
    'remind_doctor_reservation': {
        'task': 'api.tasks.period_task.remind_doctor_reservation',
        'schedule': crontab(hour=20, minute=0),
        'args': (),
    },
    'allocate_stat_doctor': {
        'task': 'statistic.tasks.allocate_stat_doctor',
        'schedule': crontab(minute=50, hour=23),
        'args': ()
    },
    'remind_order_expired_before_15_days': {
        'task': 'api.tasks.period_task.remind_order_expired_before_15_days',
        'schedule': crontab(hour=14, minute=0),
        'args': (),
    },
    'mark_reply_spam': {
        'task': 'api.tasks.period_task.mark_reply_spam',
        'schedule': crontab(minute=50, hour=23),
        'args': (),
    },
    'post_order_info_to_zhida': {
        'task': 'api.tasks.period_task.post_orders_info_to_zhida',
        'schedule': crontab(minute=10, hour=0),
        'args': ()
    },
    'order_evaluate_remind': {
        'task': 'api.tasks.period_task.order_evaluate_remind',
        'schedule': timedelta(minutes=5),
        'args': ()
    },
    'doctor_refund_timeout': {
        'task': 'api.tasks.order_task.doctor_refund_timeout',
        'schedule': timedelta(minutes=5),
        'args': ()
    },
    # ##### 统计邮件 #####
    'send_conversation_stat_mail': {
        'task': 'statistic.tasks.send_conversation_stat_mail',
        'schedule': crontab(minute=10, hour=0),
        'args': ()
    },
    'send_conversation_weekly_stat_mail': {
        'task': 'statistic.tasks.send_conversation_weekly_stat_mail',
        'schedule': crontab(minute=10, hour=0, day_of_week='tue'),
        'args': ()
    },
    'get_phone_service': {
        'task': 'api.tasks.period_task.get_phone_service',
        'schedule': timedelta(minutes=10),
        'args': (),
    },
    # ##### 统计邮件 end #####
    # ##### 美购监控 #####
    'judge_services': {
        'task': 'api.tasks.service_task.judge_services',
        'schedule': crontab(minute=50, hour=11),
        'args': ()
    },
    # ##### 美购监控 end #####
    # ##### 首页推荐feed #####
    'recommend_feed': {
        'task': 'api.tasks.recommend_feed_task.recommend_feed',
        'schedule': timedelta(minutes=5),
        'args': (),
    },
    # ##### 首页最新feed #####
    'newest_feed': {
        'task': 'api.tasks.recommend_feed_task.newest_feed',
        'schedule': timedelta(minutes=5),
        'args': (),
    },
    'remind_coupon_expire': {
        'task': 'api.tasks.period_task.remind_coupon_expire',
        'schedule': crontab(minute=0, hour=10),
        # 'schedule': timedelta(minutes=5),
        'args': (),
    },
    # repurchase reminder
    'repurchase_reminder': {
        'task': 'api.tasks.period_task.repurchase_reminder',
        'schedule': timedelta(minutes=5),
        'args': (),
    },
    # recovery reminder
    'recovery_reminder': {
        'task': 'api.tasks.recovery_reminder_task.daily_recovery_reminder',
        'schedule': crontab(minute=0, hour=20),
        'args': (),
    },
    'period_stock_alert': {
        'task': 'pay.tasks.alter_task.period_stock_alert',
        # 'schedule': crontab(minute=0, hour='0,8,16'),
        'schedule': timedelta(minutes=180),
        'args': ()
    },
    # seckill notify
    'seckill_notify': {
        'task': 'api.tasks.period_task.seckill_notify',
        'schedule': timedelta(minutes=2),
        'args': (),
    },
    'create_sleep_user_to_redis': {
        'task': 'api.tasks.user_related_tasks.create_sleep_user_to_redis',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    # 计算医生的收入分
    'calc_doctor_discount_one_day': {
        'task': 'api.tasks.order_task.calc_doctor_discount_one_day',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    'get_day_smart_rank': {
        'task': 'api.tasks.period_task.get_day_smart_rank',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    # 轮训七牛转码状态
    'check_water_mark_video_is_finish': {
        'task': 'api.tasks.live_task.check_water_mark_video_is_finish',
        'schedule': timedelta(seconds=60),
        'args': (),
    },
    # 轮训七牛转码状态（美购视频）
    'check_water_mark_video_is_finish_service': {
        'task': 'api.tasks.service_task.check_water_mark_video_is_finish_service',
        'schedule': timedelta(seconds=60),
        'args': (),
    },
    'save_replay_url': {
        'task': 'api.tasks.live_task.save_replay_url',
        'schedule': timedelta(minutes=30),
        'args': (),
    },
    # 生成直播回放帖子
    'check_live_status': {
        'task': 'api.tasks.live_task.check_live_status',
        'schedule': timedelta(minutes=2),
        'args': (),
    },
    'get_tag_top_sale_service': {
        'task': 'api.tasks.period_task.get_tag_top_sale_service',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    'add_fake_vote_num_list': {
        'task': 'api.tasks.live_task.add_fake_vote_num_list',
        'schedule': timedelta(minutes=1),
        'args': (),
    },
    # 统计crash相关关键字帖子
    # 'crash_checkout': {
    #    'task': 'api.tasks.crash_checkout.crash_check',
    #   'schedule': timedelta(hours=1),
    #  'args': (),
    # },
    "remind_user_to_validate_order": {
        'task': 'api.tasks.period_task.remind_user_to_validate_after_order_create',
        'schedule': timedelta(minutes=5),
        'args': (),
    },
    'doris_trans2es': {
        'task': 'doris.tasks.trans2es.doris_trans2es',
        'schedule': crontab(hour=2, minute=0),
    },
}

ORDER_EVALUATE_REMIND_TIME = 1

HERA_EMAIL_USER = 'doctor@wanmeizhensuo.com'
HERA_EMAIL_PSWD = 'xl60QkFtwJq6ziswn2a4r4pkFNozI13g'

ORDER_ARBIT_TIMEOUT_DELTA = 1

BOSS = 22

SETTLEMENT_SOFT_TIMEOUT = 18000
SETTLEMENT_HARD_TIMEOUT = 72000

# add by chuncheng 5.8
PAY_EMAIL_USER = 'alert@igengmei.com'
PAY_EMAIL_USER_PWD = 'X10pfvq0uxhnky4iyvuqgz9jqetvba3U'
PAY_EMAIL_STOCK_ALTER_LIST = ['yangchuncheng@igengmei.com']
PAY_EMAIL_KAITUAN_ALTER_LIST = ['yangchuncheng@igengmei.com']
PAY_EMAIL_REFUND_ALERT_LIST = ['linli@igengmei.com']

# add by huazhu 5.8
TAG_BLACK_LIST = [971, 929, 10, 13, 2214]

BACKEND_API_HOST = 'http://backend.paas-test.env'

PAY_EMAIL_STATEMENT_ALERT_LIST = []

# 400
CUSTOM_SERVICE_PHONE_API_ENDPOINT = 'http://222.73.121.26:8888/transfer/dealData.do'
CUSTOM_SERVICE_PHONE_API_ID = 'gmTest'
CUSTOM_SERVICE_PHONE_API_PASS = 'test'

SENTRY_CELERY_ENDPOINT = 'dsn-service'

STOCK_ALERT_THRESHOLD = 3

QINIU_ACCESS_KEY = "UPCOYIJkZOMcdd9FDzpBqYjzWUh55fBpVi3AhWpL"
QINIU_SECRET_KEY = "z5YvpDDSam_JE345Z8J_f3TufzelOW2VOGNoBl9e"

FEATURE_BASE_URL = 'http://backend.test.igengmei.com/hybrid/csc/'
H5_API_HOST = 'http://backend.paas.env'
FEATRUE_AGGREGATE_URL = H5_API_HOST + '/phantom/meigou/description?service_id={service_id}&checked={type}'

PUSH_NOTIFICATION_AFTER_FOLLOW_USER = True

UCPASS_DAILY_LIMIT = 5000
MAX_LOGIN_ATTEMPTES = 5000

YINGTZ_KEY_TEST = '/srv/secret/yingtz_key_test.pem'
YINGTZ_KEY_PROD = '/srv/secret/yingtz_key_prod.pem'
GMEI_PRIVATE_KEY_PKCS8 = '/srv/secret/gmei_private_key_pkcs8.pem'
YINGTZ_KEY = YINGTZ_KEY_TEST
XYMD5KEY = bytearray('74ba4d7ad1d5bc705e6c96bbf599c3f1', encoding='utf8')
QINIU_ACCESS_KEY = "UPCOYIJkZOMcdd9FDzpBqYjzWUh55fBpVi3AhWpL"
QINIU_SECRET_KEY = "z5YvpDDSam_JE345Z8J_f3TufzelOW2VOGNoBl9e"

XIAOYING_EXCEPTION_STATUS_EMAIL_LIST = [
    'dingyingcai@igengmei.com',
]

NO_REPLY_EMAIL = {
    'address': 'no-reply@igengmei.com',
    'host': 'smtp.exmail.qq.com',
    'username': 'no-reply@igengmei.com',
    'password': 'MErs@bfL85Gkwkxt554w',
}

GROUPON_SERVICE_IDS = (5269672, 4667667)

DEFAULT_TAG_ATTR_ID = 1

# weixin js sdk
# 正式账号
WX_APP_ID = 'wx19c0bdd0c9e25acb'
WX_APP_SECRET = '41855cb5fd32338435b2c7dbaa400716'
WX_USER_ID = 20889703

MAIDAN_SOFT_TIMEOUT = 6400
MAIDAN_HARD_TIMEOUT = 3600
DOUBLE_EVELEN_SPECIAL = [435]

# CUSTOM_SERVICE_PHONE_NEW = '4006999227'
# CUSTOM_SERVICE_PHONE = '4006999227'

CUSTOM_SERVICE_PHONE_NEW = '4006899900'
CUSTOM_SERVICE_PHONE = '4006899900'
DEFAULT_400_VENDOR = 'xtwy'

ZTTH_CONF = {
    'account': '01059658065',
    'user': '6016122201',
    'passwd': '88908afc672f0b599ae75b7552129a33',
    'api_domain': 'http://m.icsoc.net/',
}

DEFAULT_ZONE_ICON = 'http://hera.s.igengmei.com/circleicon/2016/11/21/a699396589'

SHOW_V = False
YUNPIAN_API_KEY = '89eea91e59166314eea3d62f2912e5a9'
YUNPIAN_HOST = 'https://sms.yunpian.com'

# Jiahua Guo
SMS_USE_SEPERATED_SERVICE = True
OPEN_RESYS = True

LIVE_MSG_REDIS_FLAG = True

QINIU_LIVE_TIMEOUT = 86400

SEND_MSG_TIME = 6
TALOS_RPC_CACHE = {'host': 'redis.paas-test.env', 'port': 6379, 'db': 14}
# TALOS_RPC_CACHE = {'host': 'redis.test.gengmei', 'port': 6379, 'db': 14}

DOCTOR_BUSINESS_CHANNAL_ID = 51

DOCTOR_USER_CAN_SEND_MSG = [
    22,
    23,
]

FENGXIANGGOU_COUPONGIFT_NEW_USER_GIFT_ID = 210
FENGXIANGGOU_COUPONGIFT_NEW_USER_CHANNEL_ID = 64

FENGXIANGGOU_COUPONGIFT_OLD_USER_GIFT_ID = 211
FENGXIANGGOU_COUPONGIFT_OLD_USER_CHANNEL_ID = 64
USE_DOC = True
TEMPLATES += [
    {
        'BACKEND': 'django.template.backends.jinja2.Jinja2',
        'APP_DIRS': True,
    },
]

REPLIES_READ_MYSQL_FLAG = True

DATA_TRANSFER_MARS_API_HOST = 'mars.test.gengmei.cc'
MULTI_TOPIC_TAG_ID = 5089

REMIND_USER_WRITE_DIARY_AFTER_ORDER_VALIDATE_DAYS = 0
REMIND_USER_WRITE_DIARY_AFTER_ORDER_VALIDATE_HOURS = 17
REMIND_USER_WRITE_DIARY_AFTER_ORDER_VALIDATE_MINUTES = 15
DBMW_LOGICAL_DATABASE_ID = 'zhengxing_test'
MIMAS_LOGICAL_DATABASE_ID = 'mimas_test'
QINIU_HUB_NAME = u'igengmei-live-test'

PUSH_FOR_SHOPCART_CHANNEL_ID = 87
PUSH_FOR_SHOPCART_GIFT_ID_AND_PERCENT = [(266, 10), (267, 7), (268, 3), (269, 20), (270, 20), (271, 20),
                                         (272, 20)]  # GiftId, Percent
# 推送限制
PUSH_TOTAL_LIMIT = 100  # 推送限制总条数
# 各子类限制的条数,注意：子类限制数要小于总数
PUSH_SUB_LIMIT = 100

SPECIAL_SHOW_COUPON_GIFT_IDS = [374]

POINT_MALL_LOTTERY_NOTHING_NUMBER = 35
POINT_MALL_LOTTERY_TRY_AGAIN_NUMBER = 50

ASYNC_TRIGGER_RECIEVE = False

SECKILL_NEW_SEPARATED_SERVICE = True
SECKILL_NEW_SEPARATED_HOSPITAL = True

GM_KV_HOSTS = [
    {
        "host": "redis.paas-test.env",
        "port": 6379,
        "db": 2
    }
]

GM_KV_URL = "redis://redis.paas-test.env:6379"

# 新版推荐美购,数据筛选项
NEW_SERVICE_RECOMMEND_FILTERS = {
    "sales_count_range": {"gte": 3},  # 售卖量 >= 100
    "related_case_count_range": {"gte": 1},  # 案例数 >= 20
}

# 小程序消息推送模板
TEMPLATE_CHECK_TEST = "zqAslWghlh-KI9E6GSuNONGKkJKrOGAF3XwaX7pteMM"  # 审核不通过模板ID
TEMPLATE_VOTE_TEST = "SA4-7118LvtET0uVZSnbzXxwxSYSM-n6jRHPMzq6NAw"  # 投票通知模板ID

#  feed卡片缓存过期时间
FEED_CARD_TIMEOUT = 15

# 商户每日主动私信数量
MERCHANT_DAILY_MESSAGE = 3

##################################################PC站支付宝配置########################################################
SANDBOX_ALIPAY_APP_APP_ID = "2016091000475625"
SANDBOX_ALIPAY_GATEWAY = "https://openapi.alipaydev.com/gateway.do"
SANDBOX_ALIPAY_APP_ALI_PUBLIC_KEY = """-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIgHnOn7LLILlKETd6BFRJ0GqgS2Y3mn1wMQmyh9zEyWlz5p1zrahRahbXAfCfSqshSNfqOmAQzSHRVjCqjsAw1jyqrXaPdKBmr90DIpIxmIyKXv4GGAkPyJ/6FTFY99uhpiq0qadD/uSzQsefWo0aTvP/65zi3eof7TcZ32oWpwIDAQAB
-----END PUBLIC KEY-----"""

SANDBOX_ALIPAY_APP_MY_PRIVATE_KEY = """-----BEGIN PRIVATE KEY-----
MIIEpQIBAAKCAQEAwQ2O9HxIj8mC02ySAA85tc6D/y1KHuVZihtvYXyket142+9faqW6PzIfNzVwad+eIVr+hguMhNQqpCFl6xuYMQgiy8mJ9sdWv5TRIjcYXGuImrK4rcLmJQPh67lUtyZZt/T/wEEAlElbt3VtqHDLSxGVRxop8NzH3yxyCmfm/CWpYy+tKDJ/rwUYvYq6gdgkioPE0CJfOfDx5icULjbfxm+YF8adeBPfdfnWshRXt63F+ij49fI/D+JIBhJWc5JrVf+KuYWONDDuovweWQq7WoM2Dhsn8Bknbn1M7PXlqKxXyRJ8R5AcnsviAwVfOuKJgESoUiXia13PCdUuoJvygQIDAQABAoIBADPlwzJyXsdYsrTHkRA3B5qaY92rfSuFGGcKLQ0WBtmIxD7LwOjYmJL4lG+xDAFKPiZVYesDG8lxh+0LlWx4xJcZytDh4xbWS7nA9d+u0/u0ZMrBlOgRZvE4c/l8nwuFYcUUNdSnJNK4TdGp3crUV7JcjbbJj9DSaWDTf+zQNcY+mgLcEDy7TL3TaELm5dtNWO6bVQy6ydwzxh9if7wd5zjwM2Pjhx3oWxGs+gn+z6JRkIR2BSFg2vlhE6/Q1UWlcVB4TvIw6cK1s8Y9PLET3D5eIay3XTvg2caFnH7Knp+n7ViyEFdHvlHB5/D49S5/WPXtpjXRg10MRh9PaCAKiOkCgYEA59j1AzodlbzG0Sg9xKilSCfYS/AnjYyBRDFSPb1uYNBmlDCVVzWwFdgs9P9CY0hI/hcFRvqE1VBCD3KvQUNlC7PlPf+olb8Uk4XPJau2U0obJOggbhSg5Owgdqw2bxGfLhl7bInDqmkTm6sknEBvorVPKiVh4ubtrOgCkzEiq+sCgYEA1SoBqKs3+CQNT2zcE18nO6YPEeGUmi9uqBwbF2IkQHAwEZbw8orRZGVVcb2eWPhtxxK73ZUpSd1xIFrTkBS7rBgvDtGFYX11iaRLpX/XR2VgP7ibZ/Hf7RQVl9pKgB48bkpSBq8QOP7gylsA5qxh/uyS6lG8R5woP31uLg6h3EMCgYEAx2rzg60PGWZgVDMavfaZA7FR+C8+th+uaCtMI9K2CAv4z2niajrBlGh2ctzEC4V3UyYV4fFFI/1+dK8eUzJWzXQUr/kg1nyehC1J+Yryrj1Fj78hdc3EfmMjoS+LOombsxkz8i2k4QS0Wucf/E3oN7lfuE6jHXmn4VtGK7jNq7UCgYEAo/FevT6SGUKBCikLScrQ/ctFo9b+12bLkHetTlqozvZ5wc15GtExIindgVD4zCylIYqC+nSSAMFTFDNGq3WGsWEYMClskAJRt76of2zHQZ3yXI+61kLsmgXsZZH54ndeuuRmGcXikDNW58r98mt6IvoINDcQu3KacdoiN0IBsskCgYEAnBnEBWVe+p3shRnAWgDMNvaGKlNN2t2NKZqWLWFL9Zv7i2AuLPL12Z9jiDiuZWrYi4iA4SMg2uJRfBvggxlXIQOMQb0oIXbe2/iy0Cl8ZBZE4q+rZXCGyZdboBNXUiTTtR1VnUlF1v2/TQ15J9ors7OpGLmtbyHaIfJ6JoASGDI=
-----END PRIVATE KEY-----"""

########################################################################################################################

# =============================================== 商家端 易宝支付配置新=================================================
YIBAO_MERCHANTNO = '10030767124'
YIBAO_APP_KEY = 'OPR:10030767124'
YIBAO_AES_SECRET_KEY = '10030767124'
YIBAO_NOTIFY_URL = 'http://exchange.env.wanmeizhensuo.com/payment/yee/callback'
YIBAO_REDIRECT_RUL = 'http://doctor.paas.env/ad_recharge'
YIBAO_SERVER_ROOT = 'https://openapi.yeepay.com/yop-center'
YIBAO_PUBLIC_KEY = """-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6p0XWjscY+gsyqKRhw9MeLsEmhFdBRhT2emOck/F1Omw38ZWhJxh9kDfs5HzFJMrVozgU+SJFDONxs8UB0wMILKRmqfLcfClG9MyCNuJkkfm0HFQv1hRGdOvZPXj3Bckuwa7FrEXBRYUhK7vJ40afumspthmse6bs6mZxNn/mALZ2X07uznOrrc2rk41Y2HftduxZw6T4EmtWuN2x4CZ8gwSyPAW5ZzZJLQ6tZDojBK4GZTAGhnn3bg5bBsBlw2+FLkCQBuDsJVsFPiGh/b6K/+zGTvWyUcu+LUj2MejYQELDO3i2vQXVDk7lVi2/TcUYefvIcssnzsfCfjaorxsuwIDAQAB
-----END PUBLIC KEY-----
"""
YIBAO_PRIVATE_KEY = """-----BEGIN PRIVATE KEY-----
MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQDDKAs4MoPj5wZcFDv+BpUxpSS7ur/JDksq3PiSBOV9JKZc99s/DaGQc3+zJkeE7i9vhdMDnz5bYNZ0G3VL7k9BFFV5c3HC2iYtVzziOs5BshMSbEL6NBJypX1HMgHAukgfOpHE8pDKBmLWk6c8qsGhh2ahbyemvad/PZuNH7sb2aKmvAEX+kmEFRLtmegZD3xehOe/bskpE7W9pCcsKEWePh/aSV/kh3HeGwjyX2r4sNzpA1FycBBLL6SzzaKo9p7Vw1RuZLKJXR4HYtcjEWz7k4iDvDQFIAKHTDBuL+KhaHyBtThFZ3vgKMXE25ezshgxXQItq1yNiuUK0FJ9nvo1AgMBAAECggEAHW06U9z6GjFJujSq3yDq+jNmmJAOPyjSmMH9ETd/yyDtnPMasiVCCWABD2hkPF0V9gD90nv+kRTHAXbqduqWNL/2K3wG2VS/kPKokYxAcZOCYLLGXqffaD4f585YiVENcvgH5uSUhIH2AVj+TJ2K2OprxUfXeML8MKl/fQYd1pL0owHLrcJsIpUD9UDlR0WR7t+4ZMRjh7kK1jKFeI+mEeOR0T7QGkKOpHaCfzRdt8mWtFvRM2cu0YIzUMz+HDHqnVvvGkALxGwc18z1sLJAq7PFEKyUclMOfsprAx97DIMsK4cHPk1xG0ONcHj6mOqJSQgT8yOSgx0mfNepwmbnQQKBgQD6xxxFbtf8plV4gbFpLQ3nMzLu39BgM1Qz/JF6DAHiPQ4DXtBy4krvXcGOIauWBnJ8zaWYNbkCdH/cvNPVqbDPTbRvB3QxZehE6aqBqW0BrHwUQ/upKED3+9cgIjt25YXfkplbdu1dWz5B79eouZhDuBMmLJbtoLO6lzwWFpb9XQKBgQDHOGreIHP1LOLssOYZQ35ddeLAirtC4C4Bim23qsSn1Z4QBsbd9KUKr+HtERTnBkLEQnhdtOhSKO/Mckdj/x3X1w5q95ErywR8/2pe9y7Fngpt9+Yg4pVYHD8U0PEZt3m6p9ZPyxdvEU7Ntubxd3R+oi8mr0gzr94D52zlQQlKuQKBgHFLkxIrSZjy7JpMvYHuwOE62D/jDZjol5oE+RRSaGd1fec35qSAZ6pMiS1VONfGgeKwZaemXbcmOr3W8T0ONLrzOBkRHQVULOM1TbrWeFDRRB1DuWZqsS9Xr5Ds5kCI4TpoWLBhwkry9eWEHcI0Vv4BI2WTr3wbphceTB8OhZhhAoGANyIU6T4/+RUgA/L86vbzzLeoNjLumhZihQijTpYS8IO8x6CofpqK5kdAlhQJHdpstdXTa9N6C+rKWmEyAqmCv84DbnTvFxiLOHCTJo7vwb74EfDuHiG2xPikOIWOg9hz9sUmGVUSOimnDmVUynSNp9IIjIMrzyoXnir4xwVVpfkCgYA6NT7nyK0PDK3X7LgzvADy21vkbAwg5KVnsT5HB9g8f2qqJaiDQSA91THbMyDELbI4/q4C1YN/fB6ewvTrUl3+UtCdrvWUxLU16NKbRd9aU5w8cDQKxNGkw2TFzw+6Ih0lHqiYtNbduJcgggUogyNwz2jb6dtKkB4zciuAsg5QKA==
-----END PRIVATE KEY-----
"""

YIBAO_API = {
    'token_uri': '/rest/v1.0/std/trade/order',
    'cashier': 'https://cash.yeepay.com/cashier/std'
}

# =======================================================================================================================

# ======================================= 第三套支付宝商户信息=========================================================
# 正式环境配置
ALIPAY_APP_APP_ID_NEW = "2019091967592269"
ALIPAY_GATEWAY_NEW = "https://openapi.alipay.com/gateway.do"
ALIPAY_APP_ALI_PUBLIC_KEY_NEW = """-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEApqpdmpTdb2fZjqWH/56oa6odDb1BYS8uo2d71NuqJhpaAZYtrCaaBe3dKmoyWUJ3cU19DBySNXkPhcmZ/eX1EfNXMhFimokt57zWzHTn4UajzvPqtyNP6BqMleUhXV+eitiyJnT3brN0u/Req0ylBEsFFRoJvxccn3oi2ECYwEcKy9lhpwntJfJl6yZefVjCq8ysk4d/fMW7y8TxaNUjez0uHTneCuiTn6zbuUf7dwr7kYoYBUOe4a1NWCP8XE5InQKEq5wK3716oET1IknZNXhIKUR1gQcm4AipHRpVdPGn6gDfpXwJQhnWCWEMuDdnH6kidqqo37sTE9uSyEwahwIDAQAB
-----END PUBLIC KEY-----"""
ALIPAY_APP_MY_PRIVATE_KEY_NEW = """-----BEGIN PRIVATE KEY-----
MIIEpQIBAAKCAQEAh69VtOUyqT74cpNPI5wK3NtY1WE5WNVLUbAoyi8bu8AqscC80TGyG0NR4SKQs2w2tDookTdjLH8rTFqYtFpG/GXJOcggeD7j5Z9XnXKAK9jql1tBlyvVs5LXH9uGHpnYpYup0+IfDy04ybnrszebG4LVzGBTqnzGqPixuiP15GSm80HVe4Gm9c6enGSsd1um0N3HE3s62VI1hRNWzEpJ6mejZ4P1KcPfH+QBF9aGaqUTz3prC1HW3L9hN2Ir8xm9k5jBWkUeVAziMKcEZ+cpM9meXbL4NrQyiKv8F46iEiTCFUeauDCKoWAM4R67OA+1eNPGBfGeqj/PRdi7yrTcAwIDAQABAoIBACAyM7Uj+bx9S7jsSYgam91CUzb2xgPVQPUWRueK/Bq2A6uAH43ILAoaFFDGwe1BTU3AyyWCLg898clBaiDJlzSG9pO2cDX4Pl2bTM/4fn9pDmlx5wN3DFN7EX7muVGDkgveMyMq8dHJGkOL0WkKVczWY+MGLHQ0/XLU6F9R7yQNgbf+hzi7/wOEpkch7GaPNMqvQb9C0D+kqa1xa8qGJ9rJUviJutnc66C+yUovhryPcd8TxoLaQgZUx9KARMPNKfKkuXIjWuzDFl9vnAkqKscwZJFJI3dUuztjQQ3uFh7dcbnZOA8wWqkChCG8uT5Mf8xLqATgJBoBXwSUJ4OzRpECgYEAvDENXQZ26NrnDLCiTR6cFuBIM12VY7iPk7NNgYCDpYcxBh9xB8X47W/htm6FFuDyqoowKb3NwztLDwm/r6cByehy63SmIrj+j1/eZ9q5new6Wu/AItR+0RbfmKWqWqHjEUgFfEAPtRF5fFfR8XJhkRXt1sjke67MigI07mMapXsCgYEAuJMFWlPVqCtW0sSopmvmaB6+KkNc2hmeA/KMA9GDiXTsaGhxbdUvv8OPFxpdjZAlo0pdvIKgQvcxBaAgTMlvphpaj83eo+T4T8cnV6U5uhNFMAJ5Jplm+KVMxJ3on8po09P5xSw/jgMuTbJTVyF1ven6Qob6t1GOFjNGGW2uKRkCgYEAotDdeuoo3nTlCPmYsZgV+0S3spj4snnu3h52o+AIBaHdLCrvo4YIQ4RUh30+7/hWem1sFfD8oDggTDZm/RVEWucc5dDaG5hpxKlwxfFaPeMu6ZYbaQbnYQalFG/f3uHIjh79f+38qO8haA6iuH35I4kRaI4N/2PP2mbmXIipeRkCgYEAlx54sX4WXrwtOCAf3TJW0UTqefvxV/jFcYHytWWjBrYeoVVyGXUExUM+MrI5iqBM0KcgnClvQaTWFD8IcxYyPZMyNq9d7F6aF+d9BLuYygrhCO/ddYb/0fC1K/4F6l50+YqC47bYylM8ZAzvQ1V362hYqIOPXux9IxwT9tngUHECgYEAiOBtTVPej+nlQuMl+e9mcf/jiwo6K3hN8NjowaoJr8GfE0pTVjXE1NqNenUOmQrP5rwtWenteD7WP1gy41hc+EFUE/Y/4dWZwem1Eb9Dqh4JMqYCBr7Qg5fxlCBRqsfZBUkfkvYZfZj7mYMZtH1pVD1dCaMJVlwZAeh0MAqS31Q=
-----END PRIVATE KEY-----"""
# 配套沙箱环境配置
# 商户账号
SANBOX_MERCHANT_ACCOUNT = "qfixtc9802@sandbox.com"
SANBOX_MERCHANT_PASSWORD = "111111"
# 买家账号
SANBOX_BUYER_ACCOUNT = "ucfkbm9248@sandbox.com"
SANBOX_BUYER_LOGIN_PASSWORD = "111111"
SANBOX_BUYER_PAY_PASSWORD = "111111"

SANDBOX_ALIPAY_GATEWAY_NEW = "https://openapi.alipaydev.com/gateway.do"
SANDBOX_ALIPAY_APP_APP_ID_NEW = "2016101400683850"
SANDBOX_ALIPAY_APP_ALI_PUBLIC_KEY_NEW = """-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAjelNWjdOfT6VmJgFpoK+sySvU4DKGf24OqWYm41syWrIfdVX56EbHa4sbvTxlE19Pz02DeM4iMxUBr+H2w5oJevelIkc4QujTrUlyfnFqv+bv0myuQo7c6pLqA5xINMi7JMBf7UsFOqxf8ilR/LUMxtVfy8MCKY84gMX0GlgMoqTxYrY4wB56/B5Iq4Kh0cdai+AmAo7IxGymdZv9SF4oVwZnaq3RYm4zWLkCY7BSBvW/vu7aWE8jizdhjhojBDMXq7cfzXy7BR0PPnFFOmvYICN+6mc7vDLY++7k+xPmJ+GVmguKhvuEtrtk5vHPmwZbCyhZDksdbiHfo4CsRTRrQIDAQAB
-----END PUBLIC KEY-----"""

SANDBOX_ALIPAY_APP_MY_PRIVATE_KEY_NEW = """-----BEGIN PRIVATE KEY-----
MIIEpQIBAAKCAQEApNsusEkdqdv2cPf7RMK+pPoYoYKh6sSkI37Jsb2NEYfuQq4A2EoC6psv0oOan0AEJNfZiLIaRBYJrdqH/4ogIfT9EjcfSusv+n/oBhDtgV1jd/FVZo9Y8n1+yQggBarT6ZXCw+ASjKDR4x5hTJmK0K8FIoGo24/4N93CyqXYWEmhID1My+AIHzrJrpWFhUhkaDy4dUbRWZwUV+rKwn1O9b9Z1cz+AG3r9qG+ebQ0a4dPBRBi8q+xYNEP7Y28RFveD/Uh3ZQl9qDDLk0xgJLMLRnxQ+p9HKiyfuXugUDHzu3DPlNxIHLkbHQXuOn5skoENfpIMpYYvrDhZ2J3TzcY4QIDAQABAoIBAQCVs1NaUYrWTCAlxYoujomAVns3buCJx7clZGTTOkV3ve/mLQwnXE35rKJoj4lBQ2h/7GJldxXS7hAsB12n903miAmnGNcZuSgAWVXg7E5AQwWoTUY3s8QZr0wKUY6ClvWID66lIDy35vGxRE0muecMSWJoS0WC2+GTGZVhX+htgjjMcWWJgidH482a9z4Al+Q7qNshWB1WCsHlmKGJJ/CKh1VhttuPwSixFuX0yXtaa03l5dDhaWzxi+OUfrzBAvHPWRcT3lOC4zCDOVFBw8ootYUhU5clvg11vX+/o9X7vIuwCfHnKwvQPBWU+ukzotvQy62Gx2DvMtuttyxgcbPhAoGBAN4FNFe2r4tyL9/0pm6YlswoP56f+SDTYGj5TDcJAPGfJg3S2yfq7bRh7qRbZYYT/x1LUuT94gswlTlq7n3PswokWW7JUH4tzAjXxLokJ+YKW/gC+uMn9AJIe0/WKPQgms1yVsB39GkvvWtTwLykPcOoE4dxWYWk1rDL01nbhG7fAoGBAL4WRsoWkTgdssHP8AO5A513KmTYNvK1e2cpO9CYB6CsoeaOinh8aRbpvIkM//o00Jkqok+SD9U38FAxmnSFHDzWHzMBlszpQPoubwzN7NORUCua7GYfszHdg671Rcdc5DiJ7IHrlB1PMaQqczNJqyPw8eAp3bulWOMSepiD6jA/AoGAPKgtWb12jmF/BO/BPLwBjvt8DilklfxJ/cQGd47FLD4v1l0CNRCxKrQKz+qMfSofa/B1UEywoh/+1PYK/GJvZtjxehwUGrUGZnAUtkpEgEvaPpMJ2l/DAZCt5+z5uWDjCjgvzVu4cbhyRs1V/fPdUAQuebWVILcdVKYLMySPNP8CgYEAuJFEtuBmrMgZU5qlf9fbLMASR8ywvcV9RtOAoq+baGV25jitNwQFvhvB1ojq23UAvlfpNb2q5erkydkAEfdVTbTSomH+nIQ3dTQ024fvVhYYc95/f0F0awyc2fqJgGQvrL4vCI9HR5YnqzEUnk3/gGxpTrEX/SU1Q3Yj14buk10CgYEA1xi2MXGa18HU6MUaCd+IZ8e7k/Mfs2sTYApReRe9flr2RK1yly12EuNJZiMfevmWJuRw8URQ24S5z1C3EEk7rhlHTh2JQlZ3I3qZIM4XF6TLeO+LgJ/hMr8lRw8sMDL+Uzd9tpOKLijqIG1/q0lGM7XCnpGOyCzxa1GjlOGNCUw=
-----END PRIVATE KEY-----"""
# ====================================================================================================================

BLACKLIST = [20899439]

# ====================================================================================================
# ======================================新微信和支付宝配置==============================================
# ====================================================================================================

GM_GATEWAY = 'http://exchange.env.wanmeizhensuo.com'

NEW_WECHAT_PID_LIST = ['1556230611', '1555124561']  # 区分新老账号退款

NEW_WECHAT_NOTIFY_URL = GM_GATEWAY + '/payment/wechat/callback'

NEW_WXAPP_WECHAT_APP_ID = 'wx113018c998de9eaf'
NEW_WXAPP_WECHAT_PARTNER_ID = '1556230611'
NEW_WXAPP_WECHAT_SECRET = 'hyJyxnyMjcmq2qwpycttz2vd5xknlwee'  # 不是微信的SECRET 是 pay.weixin.qq.com!!
NEW_WXAPP_WECHAT_PEM_KEY = '/srv/secret/wxpay/1556230611/apiclient_key.pem'
NEW_WXAPP_WECHAT_PEM_CERT = '/srv/secret/wxpay/1556230611/apiclient_cert.pem'

NEW_CLIENT_WECHAT_APP_ID = "wx403cd28c142c7d87"
NEW_CLIENT_WECHAT_PARTNER_ID = "1302548401"
NEW_CLIENT_WECHAT_SECRET = "e821f46be6ee45e3ca80d189f989313b"
# cert
NEW_CLIENT_WECHAT_PEM_KEY = "/srv/secret/client_apiclient_key.pem"
NEW_CLIENT_WECHAT_PEM_CERT = "/srv/secret/client_apiclient_cert.pem"

NEW_ALIPAY_APP_ID = "2021001102610674"
NEW_ALIPAY_PARTNER = '2088631329506836'

NEW_ALIPAY_APP_MY_PRIVATE_KEY = """-----BEGIN PRIVATE KEY-----
MIIEpAIBAAKCAQEAphr61Hn+LsUCU+6dONl3qrdCuuRkWJVTKCNE4wXOKS07E7nay8sYlekLy1m01Ee+9A9UlcWGTTrMeSObQHkRDYdNGhP4Gy1WsTyprg9A68cgyEiqXWuq/QEftYVeYsjZFZ1f3fw8oIbXqhE0/Lvo+UKLykvE99yYdq+jELAzoy/sPK9g1OWd01bHn9d39H7FjDh+piwBNADnS30ZnBqdrebV7B01OUdf79cyWGqmOSLFzJvRWYQdl/Bwn3JzCYJ/HPYRP6UJnU9o0MfTInDZR+OzdcZaPAC7uVcdjl4aq24b5oBkcUNdEXEXy3JaoSAVECv+o1AxCX7Iy59GWBgRtwIDAQABAoIBAQClTphuOPJUDVChwwjI+PP0++j3IjETT5iwi1kVLkPcCt2OZhpvUrInDwTj3WTvFm/daBxf6XIdDfVMYbkyUso70nlTCKiUM2zhemPLi/aqL0RazqZtzqcen6208wPZ/9S7hCFSRKL5hvi+kd1P4Jqc5jNEol9l5S3+gBEinJjnPzisv/TViNnl3kRyyqk2pMzSymrw+W2e8RkwhsCA6ptDzn5TexeDbqYiPpDDIQ627+tjmKr55rx6mTxH7YsdOJ3C8t5+ZhOvtiz1c6FvUZHl3qSYeuexC38TT/mqVbFG2q29np3TyVHxhpcbiOprHbzEMxKrZcxFV5nguj890uNxAoGBAP5p5EtVN4p3www9yEZBEG5rtEc83IR69yMPiJq8dn8cGZBAIbndku84g0lsGf+JKrBuUVjV+/VvL/MFwbkOZhnRraZOCmPBKD7JaRCewgnReOROUeRz8efPsPCJ1FH/pQOTZv1jUv4VM3qW7k0uQ4wBxMaVxdsiwPpaLNY2kR8rAoGBAKckIDZUdWBhVJ+o/xfyibtBvbo4XRTNM8eigFVdDtdJ9WTAIMYa3L6V8kQmhDgYU3MbwM0UsH0/yQcxStn7mUN4OurxVb9DhhfLYJXd+IyxFDh7hhM3NfnPUtXRRYtcCVKCKsbrHoPandaYyQQVV6w1lW/fiXEjAdqwIzT653GlAoGATED63yV0lzkcKgAelggMX7xCdZOlWMPubQDL5e0U6zZF5zmBok7qKm9a0lfnVvMK64S1NxY0BbVEvud7z/aj3Zs+G/mKHaoYYPFHX2bmK8EwJeXfn8Ssvdk/ZGk7TTR9hhvZI5twlZ1PJ7AzTsjOEBm7m/XqLqs1AhSjGbWTO68CgYAavDGW3y2jTA5QN6UOPJKBbIOfrPJeqHA256xleywrjb397qmPZq6Wob+N3SdbHbEDgZX2d++/KRvL1bumYJNkcm/iMtZHcNKbLcH2Vvox7wVP/5ozqqosmlgisYXRQ9iN5RpYlTVdW/PRZsEIsS1D85JCwdvnR/U8+N241MV+rQKBgQCIKK0sEoGyu4TgQuz9t6hJ0zrUI/2OsdSHlgd+mo1j6PU54FJSgAVY5ZCIRm7eGucuXKihgJCGaCiR2XORB+cSx9CuqVODLu17Fo4CfVfMiiPHxQ6c4b4JI6w6/Uwjkg03BxF1DkSiGSEN860v30xED2//W32QJjyBxR3fP50LyA==
-----END PRIVATE KEY-----"""
# 支付宝针对商家的公钥
NEW_ALIPAY_APP_ALI_PUBLIC_KEY = """-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo/Bz2nf8H/C+1/+Ic3z6WWnSimFpp+rTPTDk3X/k0f1M9elwhJU05Lq9/KLuFpEgLN6ntxIct7GAnootyVfSVEq4CQSwy54CyWRfaPYDtEFgIZR/7MLyxmlewYOFGfky1kHiA6L6EBrANxVDYFILPycz6vC9+5wqDGNs6BxnP3nUu7YGMg6apxzpcuygZc5DFsp4wyPLLPeYNDhizmv0daQvgjW8562fEDzS8Ncz1+Dn1PZvyuVp1brmsMGkHdzAKOHWqKJiIsVvjlgBiHMmJV5Hwl9Reubl1QHruhpa5Dj3RpZiNkdxC7mXbif/lny+IKLDjiVwlDiIuZ4QTdBMCQIDAQAB
-----END PUBLIC KEY-----"""
NEW_ALIPAY_NOTIFY_URL = GM_GATEWAY + '/payment/alipay/callback'

ALIPAY_USING_PARTNER = NEW_ALIPAY_PARTNER

# 视频面诊相关
QINIU_LIVE_REPLAY_DOMAIN = 'http://live-static-test.igengmei.com/'
QINIU_LIVE_DIANBO_DOMAIN = 'http://live-dianbo-test.igengmei.com/'

DECREASE_INVENTORY_BROKER_URL = "redis://redis.paas-test.env/15"

# 转诊私信相关
GENGMEI_MERCHANT = 6477328345687146383

NEW_USER_VISUAL_PAGE_ID = 303

# ai问答，获取用户选择的回答接口缓存时间【单位: 秒】
AI_QA_SELECTED_ANSWER_CACHE_TIME = 60 * 2

# 霸王餐未验证订单推送用户白名单
BWC_PUSH_USER_WHITE = [20905232]

EMAIL_LIST = ['wangxiaojun@igengmei.com','yuchao@igengmei.com']

# 新用户注册，所长发推广链接
SUOZHANG_WEL_URL = "gengmei://common_webview?url=https://backend.igengmei.com/phantom/visual_special/584"

EXPORT_UPGRADE_SERVICE_EMAIL_LIST = ['wangxiaojun@igengmei.com','17801182832@163.com']
