# -*- coding: UTF-8 -*-

import tablib
from openpyxl import load_workbook

from django.core.management import BaseCommand

from api.models import Person


class Command(BaseCommand):
    """邮件: 需求：注册用户数据排查－校园推广
    """
    def handle(self, *args, **kwargs):
        read_excel_file = u'/tmp/校园地推号码验证.xlsx'
        write_excel_file = u'/tmp/校园地推号码验证_w.xlsx'

        dt = tablib.Dataset()
        dt.headers = [u'登录手机号', u'是否为平台用户', u'注册时间']

        wb = load_workbook(read_excel_file)
        ws = wb.active
        for r in ws.rows[1:]:
            v = r[0].value
            phone = str(v)
            person = Person.objects.filter(phone=phone).first()
            if person:
                dt.append([v, u'是', person.user.date_joined.strftime('%Y-%m-%d %H:%M:%S')])
            else:
                dt.append([v, u'否', ''])

        with open(write_excel_file, 'wb') as pf:
            pf.write(dt.xlsx)
