#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2019/4/1
from django.db.models import Q
from gm_dataquery.db import DB
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery


from api.models.bd_transfer import BDTransferMonth, BDTransferMonthToBudan, BDTransferApplyRecord, BDTransferToBudan, \
    BDTransferMonthlyWithdrawalToBudan


class BDTransferMonthDB(DataBuilder):

    def getval_budan_amount(self, obj):
        return obj.month_budans.count()

    def getval_doctor__d_merchant__id(self, obj):
        return str(obj.doctor.d_merchant.id)

    def getval_business_partener_name(self, obj):
        return obj.doctor.business_partener.username

    def getval_monthly_budan_amount(self, obj):
        return obj.monthlywithdrawal_budans.count()

    def getval_all_total_amount(self, obj):
        return obj.total_amount - obj.monthly_total_amount

    def getval_all_should_pay(self, obj):
        return obj.should_pay - obj.monthly_should_pay

@DB
class BDTransferMonthDQ(DataSQLQuery):
    model = BDTransferMonth
    data_model = BDTransferMonthDB

    def filter_search_by_province(self, srch_key, srch_value, regex=False):
        return Q(doctor__hospital__city__province__id=srch_value)

    def filter_search_by_city(self, srch_key, srch_value, regex=False):
        return Q(doctor__hospital__city__id=srch_value)

    def filter_search_by_business_partener(self, srch_key, srch_value, regex=False):
        return Q(doctor__business_partener__id=srch_value)


class BDTransferMonthToBudanDB(DataBuilder):
    pass


@DB
class BDTransferMonthToBudanDQ(DataSQLQuery):
    model = BDTransferMonthToBudan
    data_model = BDTransferMonthToBudanDB


class BDTransferMonthlyWithdrawalToBudanDB(DataBuilder):
    pass


@DB
class BDTransferMonthToBudanDQ(DataSQLQuery):
    model = BDTransferMonthlyWithdrawalToBudan
    data_model = BDTransferMonthlyWithdrawalToBudanDB

class BDTransferApplyRecordDB(DataBuilder):
    def getval_doctor__d_merchant__id(self, obj):
        return str(obj.doctor.d_merchant.id)

    def getval_bbtransfer_budan_id(self, obj):
        return ','.join(obj.record_budans.values_list("budan_id", flat=True))

    def getval_coupon_total_amount(self, obj):
        total_amount = 0
        for _bdtransfermonth in obj.record_budans.all():
            total_amount += _bdtransfermonth.budan.extra_consume
        return round(total_amount,1)

    def getval_commission_total_amount(self, obj):
        total_amount = 0
        for _bdtransfermonth in obj.record_budans.all():
            total_amount += _bdtransfermonth.budan.payment
        return round(total_amount,1)

@DB
class BDTransferApplyRecordDQ(DataSQLQuery):
    model = BDTransferApplyRecord
    data_model = BDTransferApplyRecordDB

    def filter_created_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_pass_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_bbtransfer_budan_id(self, srch_key, srch_val, regex=False):
        return Q(id__in=list(BDTransferToBudan.objects.filter(
            budan_id=srch_val).values_list('bdtransferapplyrecord_id', flat=True))
                 )



