# -*- coding: UTF-8 -*-

from datetime import datetime
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from hippo.models.advertise import DeviceBlackList, IpBlackList 
from gm_dataquery.db import DB


class IpBlackDB(DataBuilder):
    def getval_create_at(self, obj):
        create_at = datetime.strftime(obj.create_at, "%Y-%m-%d %H:%M:%S")
        return create_at


@DB
class IpBlackDQ(DataSQLQuery):
    model = IpBlackList 
    data_model = IpBlackDB 

    def filter_create_at(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)


class DeviceBlackDB(DataBuilder):
    def getval_create_at(self, obj):
        create_at = datetime.strftime(obj.create_at, "%Y-%m-%d %H:%M:%S")
        return create_at

@DB
class DeviceBlackDQ(DataSQLQuery):
    model = DeviceBlackList
    data_model = DeviceBlackDB

    def filter_create_at(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)
