# -*- coding: UTF-8 -*-
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB
from rpc.exceptions import GaiaRPCFaultException
from api.models.face.skin_conf import (
    SkinAge,
    SkinOil,
    Heitou,
    Acne,
    Smoothlevel,
    HeiYanQuan,
    SkinColor,
    ActWrinkle,
    EyeBag,
    SkinType,
    BlackheadPore,
    ScanSkinVideo,
)
from gm_types.gaia import (
    KS_SKIN_ALL_TYPE,
    KS_DARK_CIRCLE_TYPE,
    KS_SKIN_TYPE,
    KS_BLACKHEAD_TYPE,
    KS_PORES_FOREHEAD_TYPE,
    KS_PORES_LEFT_CHEEK_TYPE,
    KS_PORES_RIGHT_CHEEK_TYPE,
    KS_PORES_JAW_TYPE,
    KS_PORE_TYPE,
    KS_ACNE_TYPE,
    KS_EYE_POUCH_TYPE,
    KS_NASOLABIAL_FOLD_TYPE,
    KS_SKIN_COLOR,
    KS_SKIN_SPOT_TYPE,
    KS_MOLE_TYPE,
    KS_FOREHEAD_WRINKLE_YPE,
    KS_GLABELLA_WRINKLE_YPE,
    KS_CROWS_FEET_YPE,
    KS_EYE_FINELINES_YPE,
)
from gm_types.error import ERROR


class SkinAgeDB(DataBuilder):
    def getval_name(self, obj):
        return obj.content


@DB
class SkinAgeDQ(DataSQLQuery):
    model = SkinAge
    data_model = SkinAgeDB


class SkinOilDB(DataBuilder):
    pass


@DB
class SkinOilDQ(DataSQLQuery):
    model = SkinOil
    data_model = SkinOilDB


class HeitouDB(DataBuilder):
    pass


@DB
class HeitouDQ(DataSQLQuery):
    model = Heitou
    data_model = HeitouDB


class AcneDB(DataBuilder):
    pass


@DB
class AcneDQ(DataSQLQuery):
    model = Acne
    data_model = AcneDB


class SmoothlevelDB(DataBuilder):
    pass


@DB
class SmoothlevelDQ(DataSQLQuery):
    model = Smoothlevel
    data_model = SmoothlevelDB


class HeiYanQuanDB(DataBuilder):
    pass


@DB
class HeiYanQuanDQ(DataSQLQuery):
    model = HeiYanQuan
    data_model = HeiYanQuanDB


class SkinColorDB(DataBuilder):
    pass


@DB
class SkinColorDQ(DataSQLQuery):
    model = SkinColor
    data_model = SkinColorDB


class ActWrinkleDB(DataBuilder):
    pass


@DB
class ActWrinkleDQ(DataSQLQuery):
    model = ActWrinkle
    data_model = ActWrinkleDB


class EyeBagDB(DataBuilder):
    pass


@DB
class EyeBagDQ(DataSQLQuery):
    model = EyeBag
    data_model = EyeBagDB


class SkinTypeDB(DataBuilder):

    def getval_type_value_desc(self, obj):
        # 这里做一个简单判断来更新一下数据 TODO 更新到gm_types中
        KS_EYE_POUCH_TYPE = {0: u'无眼袋', 1: u'轻度眼袋', 2: u'重度眼袋'}
        KS_NASOLABIAL_FOLD_TYPE = {0: u'无法令纹', 1: u'轻度法令纹', 2: u'重度法令纹'}
        type_map = {
            1: KS_SKIN_COLOR,
            2: KS_SKIN_TYPE,
            3: KS_DARK_CIRCLE_TYPE,
            4: KS_ACNE_TYPE,
            5: KS_SKIN_SPOT_TYPE,
            6: KS_MOLE_TYPE,
            7: KS_EYE_POUCH_TYPE,
            8: KS_EYE_FINELINES_YPE,
            9: KS_CROWS_FEET_YPE,
            10: KS_NASOLABIAL_FOLD_TYPE,
            11: KS_GLABELLA_WRINKLE_YPE,
            12: KS_FOREHEAD_WRINKLE_YPE,
        }
        type_value = type_map.get(obj.type_content)
        if type(type_value) is dict:
            result = type_value[obj.type_value]
        else:
            result = type_value.getDesc(obj.type_value)
        return result


@DB
class SkinTypeDQ(DataSQLQuery):
    model = SkinType
    data_model = SkinTypeDB


class BlackheadPoreDB(DataBuilder):
    pass


@DB
class BlackheadPoreDQ(DataSQLQuery):
    model = BlackheadPore
    data_model = BlackheadPoreDB


class ScanSkinVideoDB(DataBuilder):
    pass


@DB
class ScanSkinVideoDQ(DataSQLQuery):
    model = ScanSkinVideo
    data_model = ScanSkinVideoDB

    def update(self, updates, **kwargs):
        obj = ScanSkinVideo.objects.get(**kwargs)
        weight = updates.get("weight", 0)
        channel = updates.get("channel", 0) or obj.channel
        if weight:
            other_videos = ScanSkinVideo.objects.filter(
                weight=weight,
                channel=channel,
            ).exists()
            if other_videos:
                raise GaiaRPCFaultException(error=ERROR.UNIVERSAL, message='权重有重复', data=None)

        for k, v in updates.items():
            setattr(obj, k, v)
        obj.save()

        return 1
