# -*- coding: UTF-8 -*-

from __future__ import unicode_literals, absolute_import, print_function

import json
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB
from gm_types.pay import SUFPAY_STATUS, SUFPAY_CHANNEL

from hippo.models import Doctor, Merchant
from hippo.utils import get_merchant
from weikuan.models import HospitalPay, HospitalPayOperation


class HospitalPayDB(DataBuilder):

    def getval_gengmei_price(self, obj):
        return json.loads(obj.order.service_snapshot).get('gengmei_price')

    def getval_account_type(self, obj):
        merchant = get_merchant(obj.order.service.doctor_id)
        if merchant:
            return merchant.account.account_type
        return ''

    def getval_account_name(self, obj):
        merchant = get_merchant(obj.order.service.doctor_id)
        if merchant:
            return merchant.account.account_name
        return ''

    def getval_account_number(self, obj):
        merchant = get_merchant(obj.order.service.doctor_id)
        if merchant:
            return merchant.account.account_number
        return ''

    def getval_bank(self, obj):
        merchant = get_merchant(obj.order.service.doctor_id)
        if merchant:
            return merchant.account.bank
        return ''


@DB
class HospitalPayDQ(DataSQLQuery):
    model = HospitalPay
    data_model = HospitalPayDB

    def filter_create_at(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_order__validate_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)