# coding=utf-8
from api.models import Zone
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB


class CampaignZoneDB(DataBuilder):
    """
    活动圈子实体返回数据格式
    """

    def getval_created_time(self, obj, default=''):
        if obj.created_time:
            return str(obj.created_time)[0:19]

    # def getval_home_rank(self, obj, default=''):
    #     if obj.home_rank > 0:
    #         return obj.home_rank
    #     else:
    #         return '-'

    # def getval_circle_rank(self, obj, default=''):
    #     if obj.circle_rank > 0:
    #         return obj.circle_rank
    #     else:
    #         return '-'


@DB
class CampaignZoneDQ(DataSQLQuery):
    """
    活动圈子实体产讯过滤
    """
    model = Zone
    data_model = CampaignZoneDB
