# coding=utf-8
import json
from rpc.decorators import bind
from hera.cache.app_config import APPConfigCache
from rpc.cache import gadget_cache
from gm_types.gaia import AppConfigValueType


@bind('hera/push_gift_config/get')
def get_push_gift_config():
    app_config = APPConfigCache(gadget_cache, APPConfigCache.PUSH_AUTHORIZATION_GIFT)
    res = app_config.get_config_from_cache()
    res = json.loads(res or "{}")
    if not res:
        res = {}
    return res


@bind('hera/push_gift_config/set')
def set_push_gift_config(config_info):
    config_info = json.dumps(config_info)
    app_config = APPConfigCache(gadget_cache, APPConfigCache.PUSH_AUTHORIZATION_GIFT)
    app_config.update_app_config(config_info, AppConfigValueType.TYPE_JSON, 'push授权礼包配置')
    app_config.set_config_cache(config_info)
