# coding: utf-8
import sys
import json
from datetime import datetime, timedelta
from django.conf import settings
from gm_types.gaia import SINGLE_TYPE, TRANSFER_SOURCE, BUDAN_STATUS
from api.models import Q, BDTransferSingleRecord
from rpc.decorators import bind


reload(sys)
sys.setdefaultencoding("utf8")

uri_pre = 'hera/bdtransfer/'


@bind(uri_pre + 'payment')
def payment(user_id):
    now = datetime.now()
    zero_today = now - timedelta(hours=now.hour, minutes=now.minute, seconds=now.second, microseconds=now.microsecond)
    date_60 = zero_today - timedelta(days=60)

    query_q = ~Q(status=SINGLE_TYPE.HAS_CANCEL)
    query_q &= Q(budan__create_time__lte=zero_today)
    query_q &= Q(budan__create_time__gte=date_60)
    query_q &= ~Q(budan__status=BUDAN_STATUS.CANCEL)
    query_q &= Q(budan__create_user_id=user_id)

    single_records = BDTransferSingleRecord.objects.using(settings.SLAVE_DB_NAME).filter(query_q).prefetch_related(
        'dbtransfer', 'budan', 'user', 'confirm_user'
    )
    single_records = format_dict_sinle_records(single_records)
    return single_records


def format_dict_sinle_records(single_records):
    records = []
    for id, single_record in enumerate(single_records):
        record = dict()
        record['id'] = id + 1
        record['bdtransfer_id'] = single_record.dbtransfer_id
        record['single_record_id'] = single_record.id
        record['budan_id'] = single_record.budan.id
        record['user_name'] = single_record.dbtransfer.user
        record['user_phone'] = single_record.dbtransfer.user_phone
        record['user_wx'] = single_record.dbtransfer.wechat
        record['single_bd'] = single_record.user.username
        record['order_bd'] = single_record.budan.create_user.username
        record['single_merchant'] = single_record.doctor.merchant and single_record.doctor.merchant.name or ''
        record['order_merchant'] = single_record.budan.doctor.merchant and single_record.budan.doctor.merchant.name or ''
        record['consume'] = single_record.budan.extra_consume
        record['payment'] = single_record.budan.payment
        record['source'] = TRANSFER_SOURCE.getDesc(single_record.dbtransfer.source)
        record['order_time'] = single_record.budan.create_time.strftime('%Y-%m-%d')
        records.append(record)
    return records


@bind(uri_pre + 'commission')
def commission(user_id):
    now = datetime.now()
    zero_today = now - timedelta(hours=now.hour, minutes=now.minute, seconds=now.second, microseconds=now.microsecond)
    date_60 = zero_today - timedelta(days=60)
    bdtransfer_singlerecords = BDTransferSingleRecord.objects.filter(user_id=user_id,
                                                                     budan__isnull=False).all()
    commissions = []
    i = 1
    for bdtransfer_singlerecord in bdtransfer_singlerecords:
        bdtransferapplyrecord = bdtransfer_singlerecord.budan.record_budans.first()
        if bdtransferapplyrecord and bdtransferapplyrecord.bdtransferapplyrecord.pass_time and bdtransferapplyrecord.bdtransferapplyrecord.pass_time >= date_60 and bdtransferapplyrecord.bdtransferapplyrecord.pass_time <= zero_today:
            commission = dict()
            commission['id'] = i
            commission['single_bd'] = bdtransfer_singlerecord.budan.create_user.username
            commission['budan_id'] = bdtransfer_singlerecord.budan.id
            commission['pass_time_month'] = bdtransferapplyrecord.bdtransferapplyrecord.pass_time.strftime('%Y-%m')
            commission['apply_id'] = bdtransferapplyrecord.bdtransferapplyrecord.id
            commission['merchant_id'] = bdtransfer_singlerecord.budan.doctor.merchant and bdtransfer_singlerecord.budan.doctor.merchant.id or ''
            commission['merchant_name'] = bdtransfer_singlerecord.budan.doctor.merchant and bdtransfer_singlerecord.budan.doctor.merchant.name or ''
            commission['project_name'] = ';'.join([_['name'] for _ in json.loads(bdtransfer_singlerecord.budan.dev_projects)])
            commission['consume'] = bdtransfer_singlerecord.budan.extra_consume
            commission['commission'] = bdtransfer_singlerecord.budan.payment
            commission['pass_time'] = bdtransferapplyrecord.bdtransferapplyrecord.pass_time.strftime('%Y-%m-%d %H:%M:%S')
            i += 1
            commissions.append(commission)
    return commissions