# coding=utf-8
import json

from rpc.decorators import bind
from mark.models import MarkFortuneConfigs, MarkActivity
from api.models.face.skin_conf import SkinAge


@bind('hera/mark_fortune_configs')
def mark_fortune_configs(id):
    res = []
    configs = MarkFortuneConfigs.objects.filter(mark_activity_id=id, is_online=True)
    skin_trait_ids = [item.skin_trait_id for item in configs]
    if not skin_trait_ids:
        return res
    skin_id_content_dic = dict(SkinAge.objects.filter(id__in=skin_trait_ids).values_list('id', 'content'))
    for config in configs:
        content = skin_id_content_dic.get(config.skin_trait_id)
        if not content:
            continue
        res.append({
            'id': config.id,
            'constellation': config.constellation,
            'content': content,
            'is_online': config.is_online,
        })
    return res


@bind('hera/mark_activity_get')
def get_mark_activity(activity_id):
    try:
        activity = MarkActivity.objects.get(id=activity_id)
        return {
            "solid_title": activity.solid_title,
            "hollow_title": activity.hollow_title,
            "mark_type": activity.mark_type,
            "remind_desc": activity.remind_desc,
        }
    except MarkActivity.DoesNotExist:
        return {}


def get_fitting_or_dread_by_index(fitting_and_dread, i, is_fitting=True, is_content=True):
    res = ''
    if not fitting_and_dread:
        return res

    if is_fitting:
        fitting_or_dread = fitting_and_dread.get('fitting', [])
    else:
        fitting_or_dread = fitting_and_dread.get('dread', [])

    if len(fitting_or_dread) >= i + 1:
        if is_content:
            res = fitting_or_dread[i].get('content', '')
        else:
            res = fitting_or_dread[i].get('icon', '')
    return res


def get_note_by_index(notes, i):

    res = ''
    if not notes:
        return res

    if len(notes) >= i + 1:
        res = notes[i]
    return res


@bind('hera/activity_conf/get')
def get_activity_conf_by_activity_id(activity_id, config_id):
    """
    :param activity_id:
    :param config_id:
    :return:
    """
    try:
        config = MarkFortuneConfigs.objects.get(id=config_id)
    except MarkFortuneConfigs.DoesNotExist:
        return {}

    notes = json.loads(config.notes)
    fitting_and_dread = json.loads(config.fitting_and_dread)

    result = {
        "mark_activity_id": config.mark_activity_id,
        "skin_trait_id": config.skin_trait_id,
        "title": config.title,
        "constellation": config.constellation,
        "blood_type": config.blood_type,
        "note_1": get_note_by_index(notes, 0),
        "note_2": get_note_by_index(notes, 1),
        "note_3": get_note_by_index(notes, 2),
        "note_4": get_note_by_index(notes, 3),
        "note_5": get_note_by_index(notes, 4),
        "note_6": get_note_by_index(notes, 5),
        "should_1_content": get_fitting_or_dread_by_index(fitting_and_dread, 0),
        "should_1_icon": get_fitting_or_dread_by_index(fitting_and_dread, 0, is_content=False),
        "should_2_content": get_fitting_or_dread_by_index(fitting_and_dread, 1),
        "should_2_icon": get_fitting_or_dread_by_index(fitting_and_dread, 1, is_content=False),

        "avoid_1_content": get_fitting_or_dread_by_index(fitting_and_dread, 0, is_fitting=False),
        "avoid_1_icon": get_fitting_or_dread_by_index(fitting_and_dread, 0, is_fitting=False, is_content=False),
        "avoid_2_content": get_fitting_or_dread_by_index(fitting_and_dread, 1, is_fitting=False),
        "avoid_2_icon": get_fitting_or_dread_by_index(fitting_and_dread, 1, is_fitting=False, is_content=False),
    }

    return result


@bind('hera/activity_conf/edit')
def config_edit(config_data, mark_activity_id, config_id=None):
    notes = []
    fitting_and_dread = {"fitting": [], "dread": []}
    # {"fitting": [{"content": "宜文案", "icon": "宜ICON"}, ], "dread": [{"content": "忌文案", "icon": "忌ICON"}, ]}
    fitting_and_dread['fitting'].append({
        "content": config_data.get('should_1_content', ''),
        "icon": config_data.get('should_1_icon', ''),
    })
    fitting_and_dread['fitting'].append({
        "content": config_data.get('should_2_content', ''),
        "icon": config_data.get('should_2_icon', ''),
    })
    fitting_and_dread['dread'].append({
        "content": config_data.get('avoid_1_content', ''),
        "icon": config_data.get('avoid_1_icon', ''),
    })
    fitting_and_dread['dread'].append({
        "content": config_data.get('avoid_2_content', ''),
        "icon": config_data.get('avoid_2_icon', ''),
    })

    notes.extend([
        config_data.get('note_1', ''), config_data.get('note_2', ''), config_data.get('note_3', ''),
        config_data.get('note_4', ''), config_data.get('note_5', ''), config_data.get('note_6', ''),
    ])

    object_data = {
        "mark_activity_id": mark_activity_id,
        "skin_trait_id": config_data.get('skin_trait_id') or 0,
        "title": config_data.get('title', ''),
        "constellation": config_data.get('constellation'),
        "blood_type": config_data.get('blood_type', ''),
        "notes": json.dumps(notes),
        "fitting_and_dread": json.dumps(fitting_and_dread),
    }

    if not config_id:
        config = MarkFortuneConfigs.objects.create(**object_data)
    else:
        config = MarkFortuneConfigs.objects.get(id=config_id)
        for k, v in object_data.items():
            setattr(config, k, v)
        config.save()

    return {
        'error': 0,
        'data': {
            'config_id': config.id,
            'mark_activity_id': mark_activity_id,
        },
        "message": '',
    }
