# coding=utf-8
from __future__ import unicode_literals

from api.models.word import SynonymGroup
from rpc.decorators import bind


@bind('hera/synonym_group')
def get_synonym_group(group_id):
    synonym_group = SynonymGroup.objects.get(id=group_id)
    return {
        'group_id': group_id,
        'words_list': synonym_group.words_list,
        'words_string': synonym_group.words_string,
    }


@bind('hera/synonym_group_edit')
def synonym_group_edit(group_id, data):
    if group_id:
        action = 'modify'
        group = SynonymGroup.objects.get(id=group_id)
    else:
        action = 'create'
        group = SynonymGroup.objects.create()
    word_to_add = data.get('word_to_add')
    if word_to_add:
        group.add_words([word_to_add])
    return {
        'group_id': group.id,
        'action': action,
        'words_list': group.words_list,
        'words_string': group.words_string,
    }


@bind('hera/synonym_del_words')
def synonym_del_words(group_id, words):
    print(words)
    group = SynonymGroup.objects.get(id=group_id)
    group.del_words(words)
    return {
        'group_id': group_id,
        'action': 'delete_words',
        'words_list': group.words_list,
        'words_string': group.words_string,
    }
