#coding=utf-8
import tablib
from django.core.management import BaseCommand

from hera.management.commands.utils import get_mail
from hippo.models import Merchant, Team


class Command(BaseCommand):
    """
    商户关联商务信息导出
    python manage.py merchant_BD_export
    """

    def handle(self, *args, **options):
        dt_success = tablib.Dataset()
        dt_success.headers = (u'商户名称', u'商户id', u'商务区域', u'关联商务专员')
        merchants = Merchant.objects.all()
        for merchant in merchants:
            print(merchant.id)
            try:
                business = merchant.doctor.business_partener.last_name
            except:
                business = ''
            try:
                team_name = Team.objects.get(id=merchant.doctor.business_group).name
            except:
                team_name = ''
            dt_success.append((merchant.name, merchant.id, team_name, business))
        get_mail('商户信息统计.xlsx', '商户关联商务区域及商务专员统计',['songzhenqi@igengmei.com', 'weiyujie@igengmei.com'],dt_success.xlsx).send()
