#coding=utf-8
from django.core.management import BaseCommand

from hippo.tasks import update_merchant_level


class Command(BaseCommand):
    """
    添加商户等级
    python manage.py merchant_add_level
    """

    def add_arguments(self, parser):
        parser.add_argument(
            '--month', type=float, help='月份', default= 6.0
        )

        parser.add_argument(
            '--end_time', type=str, help='结束时间', default= None
        )

    def handle(self, end_time, month, **options):
        update_merchant_level(end_time, month)