#coding=utf-8
from django.core.management import BaseCommand

from hippo.tasks import merchant_level_info


class Command(BaseCommand):
    """
    商户抽成、广告、佣金信息统计
    python manage.py merchant_level_info
    """

    def add_arguments(self, parser):

        parser.add_argument(
            '--begin_time', type=str, help='开始时间', default= None
        )
        parser.add_argument(
            '--month', type=float, help='月份', default= 6
        )

    def handle(self, begin_time, month,  **options):
        merchant_level_info(begin_time, month)