#coding=utf-8
import tablib
from django.core.management import BaseCommand
from openpyxl import load_workbook

from api.tasks.export_maidan_order_task import get_mail
from hippo.models import Hospital


class Command(BaseCommand):
    """
    批量写入医院别名
    python manage.py write_hospitals_alias_name
    """
    def handle(self, *args, **options):
        workbook = load_workbook('./hospital_name.xlsx', read_only=True, data_only=True)
        dt_success = tablib.Dataset()
        dt_success.headers = (u'医院id', u'医院别名')
        for item in workbook['abbreviation']:
            hospital_id = item[3].value
            alias_name = item[8].value
            print(hospital_id, alias_name)
            try:
                obj = Hospital.objects.get(id=hospital_id)
                obj.alias_name = alias_name
                obj.save()
            except:
                dt_success.append((hospital_id, alias_name))
                pass
        get_mail(u'医院别名写入', u'别名修改失败统计', u'songzhenqi@igengmei.com', dt_success).send()