# coding=utf-8

from django.core.management import BaseCommand
from gm_types.gaia import DOCTOR_TYPE

from hippo.models import Doctor
from lasker.models import Participant


class Command(BaseCommand):

    def add_arguments(self, parser):
        parser.add_argument('doctor_id', help=u"医生或者机构管理者ID")

    def handle(self, *args, **options):
        doctor_id = options['doctor_id']
        doctor = Doctor.objects.filter(id=doctor_id).first()
        if not doctor:
            self.stdout.write(self.style.ERROR(u'ID 为 {} 的医生或者机构管理者不存在!'.format(doctor_id)))
            return
        participants = Participant.objects.filter(
            award__lasker__year=2018, award__lasker__name=u"金刀奖", doctor_id=doctor_id
        ).values_list('id', 'award__name', 'votes_num')
        if not participants:
            self.stdout.write(self.style.ERROR(u'该医生或者机构管理者未参加评选!'))
            return
        if doctor.doctor_type == DOCTOR_TYPE.DOCTOR:
            self.stdout.write(self.style.NOTICE(u'ID 为 {} 查询到是普通医生, 用户名为 {}'.format(doctor_id, doctor.name)))
        else:
            self.stdout.write(self.style.NOTICE(u'ID 为 {} 查询到是机构管理者, 用户名为 {}'.format(doctor_id, doctor.name)))

        for id, award_name, votes_num in participants:
            self.stdout.write(self.style.NOTICE(u'奖项ID:{}    奖项名称:{}    投票数:{}'.format(id, award_name, votes_num)))
        self.stdout.write(self.style.NOTICE('END'))
