#!/usr/bin/env python
# -*- coding: utf-8 -*-

import time

from django.core.management.base import BaseCommand
from utils.execel import ExcelReader
from launch.models.ai_qa import AIConsultInfo


class Command(BaseCommand):
    """
    python manage.py ai_qa_consult_import_data --file_path
    """

    def add_arguments(self, parser):
        parser.add_argument(
            '--file_path',
            help=u'xls文件路径'
        )

    def handle(self, *args, **options):
        print("START")
        start_time = time.time()
        file_path = options.get("file_path", "")
        if not file_path:
            print("参数有误，请重新输入!")
            return

        excel = ExcelReader(file_path)
        total_row_number = excel.row_number
        valid_num = 0
        for row in range(2, total_row_number):
            _id, title, status = excel.read_row(row)
            obj, update_status = AIConsultInfo.objects.update_or_create(
                pk=_id,
                title=title,
                defaults={"is_online": status}
            )
            if update_status:
                valid_num += 1

        end_time = time.time()
        print("total time:{}, total_num:{}, processing num:{} ".format(
            round((end_time - start_time), 2),
            total_row_number - 2,
            valid_num
        ))
        print("END")
