#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.contrib.auth.models import User
from django.db import models
from django.utils import timezone

from gm_types.gaia import (
    PROBLEM_TYPE,
    PORTRAIT_TYPE,
)
from gm_upload import ImgUrlField, IMG_TYPE

from api.models import Tag


class QuestionnaireTheme(models.Model):
    class Meta:
        verbose_name = u'问卷主题'
        db_table = 'api_questionnaire_theme'

    theme = models.TextField(verbose_name=u'问卷主题', null=False, default="")
    operator = models.ForeignKey(User, verbose_name=u'修改人')
    is_online = models.BooleanField(verbose_name=u'是否在线', default=False)
    create_time = models.DateTimeField(u"创建时间", auto_now_add=True)
    update_time = models.DateTimeField(u'更新时间', auto_now=True)
    last_modified = models.DateTimeField(verbose_name=u'最后修改时间', default=timezone.now)


# TODO 等数据同步到 下边新建的关联关系表，废弃
class QuestionnaireQuestion(models.Model):  # TODO 待废弃
    class Meta:
        verbose_name = u'问卷问题'
        db_table = 'api_questionnaire_question'

    questionnaire_theme = models.ForeignKey(QuestionnaireTheme, verbose_name=u'关联主题')
    title = models.CharField(max_length=128, null=False, verbose_name=u'问题标题')
    problem_type = models.IntegerField(verbose_name=u'类型', default=PROBLEM_TYPE.MULTIPLE_PLANS, choices=PROBLEM_TYPE)
    relation_question_id = models.IntegerField(verbose_name=u"关联的社区问题id", default=0)
    rank = models.IntegerField(verbose_name=u'排序', default=999)
    is_effect = models.BooleanField(verbose_name=u'是否生效', default=True)
    is_delete = models.BooleanField(verbose_name=u"是否删除", default=False)
    is_influence_user_portrait = models.BooleanField(verbose_name=u'是否影响用户画像')
    create_time = models.DateTimeField(u"创建时间", auto_now_add=True)
    update_time = models.DateTimeField(u'更新时间', auto_now=True)


class QuestionnaireQuestions(models.Model):
    class Meta:
        verbose_name = u'问卷问题'
        db_table = 'api_questionnaire_questions'

    title = models.CharField(max_length=128, null=False, verbose_name=u'问题标题')
    problem_type = models.IntegerField(verbose_name=u'类型', default=PROBLEM_TYPE.MULTIPLE_PLANS, choices=PROBLEM_TYPE)
    portrait_type = models.IntegerField(verbose_name=u'画像类型', default=PORTRAIT_TYPE.INTERESTED, choices=PORTRAIT_TYPE)
    relation_question_id = models.IntegerField(verbose_name=u"关联的社区问题id", default=0)
    is_effect = models.BooleanField(verbose_name=u'是否生效', default=True)
    is_delete = models.BooleanField(verbose_name=u"是否删除", default=False)
    is_influence_user_portrait = models.BooleanField(verbose_name=u'是否影响用户画像', default=False)
    is_filter_selected_answer = models.BooleanField(verbose_name=u"是否过滤已选答案", default=True)
    create_time = models.DateTimeField(u"创建时间", default=timezone.now)
    update_time = models.DateTimeField(u'更新时间', auto_now=True)


class QuestionnaireThemeAndQuestionRelations(models.Model):
    class Meta:
        verbose_name = u'问卷主题、问题关联关系'
        db_table = 'api_questionnaire_theme_and_question_relations'

    questionnaire_theme_id = models.IntegerField(verbose_name=u"主题id", db_index=True)
    questionnaire_question_id = models.IntegerField(verbose_name=u"问题id", db_index=True)
    can_skip = models.BooleanField(verbose_name=u'能否跳过', default=False)
    sub_questions_show_nums = models.IntegerField(verbose_name=u"最多展示几组子问题", default=0)
    rank = models.IntegerField(verbose_name=u'排序', default=999)
    send_message = models.BooleanField(verbose_name=u'询问用户是否联系医生', default=False)


class QuestionnaireAnswer(models.Model):
    class Meta:
        verbose_name = u'问卷答案'
        db_table = 'api_questionnaire_answer'

    questionnaire_question_id = models.IntegerField(verbose_name=u'关联问题id', db_index=True)
    questionnaire_display_content = models.CharField(max_length=128, null=False, verbose_name=u'外显文案')
    questionnaire_content = models.CharField(max_length=128, null=False, verbose_name=u'答案')
    questionnaire_image_url = ImgUrlField(img_type=IMG_TYPE.NOWATERMARK, verbose_name=u'图片', max_length=256)
    answer_create_content = models.TextField(verbose_name=u'回答创建文案', null=False, default="")
    answer_create_image_url = ImgUrlField(img_type=IMG_TYPE.NOWATERMARK, verbose_name=u'回答创建图片', max_length=256)
    relation_question_id = models.IntegerField(verbose_name=u"关联的社区问题id", default=0)
    is_delete = models.BooleanField(verbose_name=u"是否删除", default=False)
    is_ugc = models.BooleanField(verbose_name=u'是否支持ugc(用户创建)', default=False)
    is_force_display = models.BooleanField(verbose_name=u'是否强制展示', default=False)  # hera后台展示 答案必出（默认末尾)
    rank = models.IntegerField(verbose_name=u'排序(指在问题详情页的展示顺序，数字越小越靠前)', default=999)
    create_time = models.DateTimeField(u"创建时间", auto_now_add=True)
    update_time = models.DateTimeField(u'更新时间', auto_now=True)


class QuestionnaireAnswerRelationTag(models.Model):
    class Meta:
        verbose_name = u'问卷答案关联标签'
        db_table = 'api_questionnaire_answer_relation_tag'

    questionnaire_answer = models.ForeignKey(QuestionnaireAnswer, verbose_name=u'关联答案')
    tag = models.ForeignKey(Tag, verbose_name=u'回答关联tag')
    create_time = models.DateTimeField(u"创建时间", auto_now_add=True)
    update_time = models.DateTimeField(u'更新时间', auto_now=True)


class QuestionnaireAnswerRelationTagV3(models.Model):
    class Meta:
        verbose_name = u'问卷答案关联标签'
        db_table = 'api_questionnaire_answer_relation_tag_v3'

    questionnaire_answer = models.ForeignKey(QuestionnaireAnswer, verbose_name=u'关联答案')
    tag_v3_id = models.IntegerField(verbose_name=u'标签3.0', db_index=True)
    create_time = models.DateTimeField(u"创建时间", auto_now_add=True)
    update_time = models.DateTimeField(u'更新时间', auto_now=True)


# v 7.29.0 date 2020.06.09 update 产品去除属性类规则
class QuestionnaireAnswerRelationAttrTag(models.Model):
    class Meta:
        verbose_name = u'问卷答案关联属性标签'
        db_table = 'api_questionnaire_answer_relation_attrtag'

    questionnaire_answer = models.ForeignKey(QuestionnaireAnswer, verbose_name=u'关联答案')
    attr_tag_id = models.IntegerField(verbose_name=u'属性标签', db_index=True)
    create_time = models.DateTimeField(u"创建时间", auto_now_add=True)
    update_time = models.DateTimeField(u'更新时间', auto_now=True)


class QuestionnaireAnswerInterestQuestion(models.Model):
    class Meta:
        verbose_name = u'问卷答案关联感兴趣的问题'
        db_table = 'api_questionnaire_answer_interest_question'

    questionnaire_answer_id = models.IntegerField(verbose_name=u"问卷答案id", db_index=True)
    question_id = models.IntegerField(verbose_name=u"关联的社区问题id", default=0, db_index=True)


class QuestionnaireQaSubRelations(models.Model):
    # 某主题下问题的回答 可以关联多个子问题
    class Meta:
        verbose_name = u'某主题下答案与子问题关联关系表'
        db_table = 'api_questionnaire_qa_sub_relations'

    questionnaire_theme_id = models.IntegerField(verbose_name=u"主题id", db_index=True)
    questionnaire_question_id = models.IntegerField(verbose_name=u"问题id", db_index=True)
    questionnaire_answer_id = models.IntegerField(verbose_name=u"回答id", db_index=True)
    questionnaire_sub_question_id = models.IntegerField(verbose_name=u"子问题id", db_index=True)
    weight = models.IntegerField(verbose_name=u'权重(回答下子问题优先展示判断，数字越小越靠前)', default=999)  # 不同主题下相同问题的回答权重可能不一样
    can_skip = models.BooleanField(verbose_name=u'能否跳过', default=False)
    is_series_answer = models.BooleanField(verbose_name=u'是否按子问题配置的ugc问题分别串联回答（仅主问题的答案配置有效）', default=False)
