# coding=utf8

from django.contrib.auth.models import User
from django.db import models
from gm_types.gaia import SERVICE_SCREEN_LABEL


class ShortcutScreenLabel(models.Model):
    class Meta:
        verbose_name = u'快捷筛选标签配置'
        db_table = 'api_shortcut_screen_label'

    title = models.IntegerField(verbose_name=u'快捷筛选名称', choices=SERVICE_SCREEN_LABEL, default=SERVICE_SCREEN_LABEL.DEFAULT)
    position = models.IntegerField(default=1, verbose_name=u'位置')
    start_time = models.DateTimeField(verbose_name=u'开始时间')
    end_time = models.DateTimeField(verbose_name=u'结束时间')
    create_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now_add=True)
    operator = models.ForeignKey(User, verbose_name=u'操作人')
    is_delete = models.BooleanField(null=False, default=False)
