# coding=utf-8
from __future__ import unicode_literals, absolute_import

from django.db import models
from gm_types.gaia import SLIDE_USER_TYPE, SERVICE_EVENT_TYPE

from api.models import Special, Region, City

class ServiceConfigureRelevant(models.Model):
    class Meta:
        verbose_name = '美购配置相关'
        db_table = 'launch_serviceconfigurerelevant'
        app_label = 'launch'

    title = models.CharField(verbose_name=u'标题', max_length=128, default='')
    user_type = models.IntegerField(verbose_name=u'用户类型', choices=SLIDE_USER_TYPE,
                                    default=SLIDE_USER_TYPE.ALL_USER)
    start_time = models.DateTimeField(null=True, verbose_name=u'开始时间')
    end_time = models.DateTimeField(null=True, verbose_name=u'结束时间', blank=True)
    special = models.ForeignKey(Special, verbose_name=u'关联专题', null=True, blank=True)
    event_type = models.IntegerField('事件类型', default=SERVICE_EVENT_TYPE.NEW_OLD_USER, choices=SERVICE_EVENT_TYPE,
                                     null=True, db_index=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class ServiceConfigureRelationCity(models.Model):
    class Meta:
        verbose_name = u'展现城市'
        app_label = 'launch'

    city = models.ForeignKey(City, verbose_name=u"城市ID", help_text=u"城市ID")
    create_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    service_configure_relevant = models.ForeignKey(ServiceConfigureRelevant, verbose_name=u"美购相关配置", related_name='servicehome_city')


class ServiceConfigureRelationRegion(models.Model):
    class Meta:
        verbose_name = u'展示大区'
        app_label = 'launch'

    region = models.ForeignKey(Region, verbose_name=u'展示大区')
    create_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    service_configure_relevant = models.ForeignKey(ServiceConfigureRelevant, verbose_name=u'美购相关配置', related_name='servicehome_region')

