#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.db import models
from django.utils import timezone

from gm_types.gaia import SKIN_DATA_SOURCE


class UserMarkLog(models.Model):
    class Meta:
        verbose_name = '用户打卡记录'
        db_table = 'api_mark_log'

    user_id = models.IntegerField(verbose_name=u"用户ID", db_index=True)
    device_id = models.CharField(verbose_name=u"设备ID", max_length=128, default="", db_index=True)

    skin_result_id = models.IntegerField(verbose_name=u"关联测肤记录ID", default=0, db_index=True)
    skin_data_source = models.CharField(verbose_name=u"测肤数据来源", max_length=12, choices=SKIN_DATA_SOURCE)

    mark_activity_id = models.IntegerField(verbose_name=u"关联打卡活动ID", db_index=True)
    mark_fortune_id = models.IntegerField(verbose_name=u"用户具体运势ID(冗余字段，记录运势)", default=0)
    mark_date = models.DateField(verbose_name=u'打卡日期', default=timezone.now, db_index=True)

    create_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class UserMarkLogStatistic(models.Model):
    class Meta:
        verbose_name = '用户打卡记录统计表'
        db_table = 'api_mark_log_statistic'

    user_id = models.IntegerField(verbose_name=u"用户ID", db_index=True)
    device_id = models.CharField(verbose_name=u"设备ID", max_length=128, default="", db_index=True)

    mark_activity_id = models.IntegerField(verbose_name=u"关联打卡活动ID", db_index=True)
    mark_date = models.DateField(verbose_name=u'打卡日期', default=timezone.now, db_index=True)

    daily_check_nums = models.IntegerField(verbose_name=u"打卡次数", default=0)
