# coding: utf-8
from datetime import datetime
from datetime import timedelta
from django.core.management import BaseCommand
from api.models.message import Message


class Command(BaseCommand):
    """
    由于新上线的自动回复功能， 产生了一批医生主动发送的私信，
    这部分消息不应该纳入 扣费项中， 需要修正一下消息标识
    """
    def handle(self, *args, **options):

        today = datetime(2019, 12, 6)
        start_datetime = datetime.combine(today, datetime.min.time())
        end_datetime = datetime.combine(today + timedelta(days=1), datetime.min.time())

        # 根据内容 找到 非系统自动发送类型的 自动回复(统计发现实际数据中不存在该内容的用户数据)
        messages = Message.objects.filter(
            send_time__gte=start_datetime,
            send_time__lt=end_datetime,
            content="您好，请问您想了解什么？",
            is_system=False)

        assert messages.count() == 1091

        Message.objects.filter(
            send_time__gte=start_datetime,
            send_time__lt=end_datetime,
            content="您好，请问您想了解什么？",
            is_system=False
        ).update(is_system=True)

        print("done")
