-- Deploy gaia-message:2020_04_30_voice_alert_create_table to mysql

BEGIN;
CREATE TABLE `voice_alert_record` (
	`id` integer NOT NULL PRIMARY KEY AUTO_INCREMENT,
	`merchant_id` bigint NOT NULL,
	`message_receiver_user_id` integer NOT NULL,
	`alert_time` datetime(6) NOT NULL,
	`connect_status` integer NOT NULL,
	`call_duration` DOUBLE PRECISION NOT NULL,
	`connect_duration` DOUBLE PRECISION NOT NULL,
	`vms_callid` varchar(128) NULL,
	`message_id` integer NOT NULL
);
CREATE TABLE `voice_alert_setting` (
	`id` integer NOT NULL PRIMARY KEY AUTO_INCREMENT,
	`merchant_id` bigint NOT NULL,
	`alert_interval` integer NOT NULL
);
CREATE TABLE `voice_alert_staff` (
	`id` integer NOT NULL PRIMARY KEY AUTO_INCREMENT,
	`merchant_id` bigint NOT NULL,
	`name` varchar(128) NOT NULL,
	`phone` varchar(32) NOT NULL
);
CREATE TABLE `voice_alert_staff_duty_table` (
	`id` integer NOT NULL PRIMARY KEY AUTO_INCREMENT,
	`start_time` DOUBLE PRECISION NOT NULL,
	`end_time` DOUBLE PRECISION NOT NULL,
	`weekday` integer NOT NULL,
	`setting_id` integer NOT NULL,
	`staff_id` integer NOT NULL
);
ALTER TABLE `voice_alert_record`
	ADD COLUMN `receive_staff_id` integer NOT NULL;
ALTER TABLE `voice_alert_record`
	ALTER COLUMN `receive_staff_id` DROP DEFAULT;
ALTER TABLE `voice_alert_record`
	ADD CONSTRAINT `voice_alert_re_message_id_5474fd2b8206e711_fk_message_message_id` FOREIGN KEY (`message_id`) REFERENCES `api_message` (`id`);
ALTER TABLE `voice_alert_staff_duty_table`
	ADD CONSTRAINT `voice_aler_setting_id_52360f3f3f5a309b_fk_voice_alert_setting_id` FOREIGN KEY (`setting_id`) REFERENCES `voice_alert_setting` (`id`);
ALTER TABLE `voice_alert_staff_duty_table`
	ADD CONSTRAINT `voice_alert_st_staff_id_48430b966dd0369f_fk_voice_alert_staff_id` FOREIGN KEY (`staff_id`) REFERENCES `voice_alert_staff` (`id`);
CREATE INDEX `voice_alert_record_c1deeef6` ON `voice_alert_record` (`receive_staff_id`);
ALTER TABLE `voice_alert_record`
	ADD CONSTRAINT `voice__receive_staff_id_6152331a209e1216_fk_voice_alert_staff_id` FOREIGN KEY (`receive_staff_id`) REFERENCES `voice_alert_staff` (`id`);
COMMIT;
