# coding=utf-8
from __future__ import unicode_literals, absolute_import

from django.db import models

from api.models import Settlement
from pay.manager import AlipaySettlementManager


class MomoStatLog(models.Model):
    class Meta:
        verbose_name = '陌陌打点请求记录'
        verbose_name_plural = '陌陌打点请求记录'
        db_table = 'pay_momo_stat_log'
        app_label = 'pay'

    status = models.IntegerField(default=0)

    created_at = models.DateTimeField(auto_now_add=True, verbose_name="创建时间")
    updated_at = models.DateTimeField(auto_now_add=True, verbose_name="更新时间")

    message_type = models.IntegerField(verbose_name="打点消息类型")
    json_text = models.TextField(verbose_name="打点消息JSON")
