# -*- coding: utf-8 -*-
# @Time    : 2020/3/13 7:13 PM
# @Author  : hexy
import time
from django.conf import settings
from redis import ConnectionPool, StrictRedis
from rpc.tool.log_tool import repeat_refund_logger
import json
def getRedisClient(host=None, port=None, db=None, password=None, **kwargs):
    pool = ConnectionPool(host=host, port=port, db=db, password=password)
    return StrictRedis(connection_pool=pool)

redis_client = getRedisClient(**settings.DEFAULT_REDIS)

from rpc.context import create_fake_context
ctx = create_fake_context()


class RefundTool:

    __refund_apply_key = 'pay:order:refund:apply'
    __refund_success_key = 'pay:order:refund:success'

    __weikuan_refund_apply_key = 'weikuan:order:refund:apply'
    __weikuan_success_key = 'weikuan:order:refund:success'

    @staticmethod
    def add_refund_applay_order(order_id):
        redis_client.sadd(RefundTool.__refund_apply_key,order_id)

    @staticmethod
    def get_refund_applay_orders():
        return list(redis_client.smembers(RefundTool.__refund_apply_key))

    @staticmethod
    def add_refund_success_order(order_id):
        redis_client.sadd(RefundTool.__refund_success_key, order_id)

    @staticmethod
    def get_refund_fial_orders():
        return list(redis_client.sdiff(RefundTool.__refund_apply_key,RefundTool.__refund_success_key))

    @staticmethod
    def add_weikuan_refund_applay_order(order_id):
        redis_client.sadd(RefundTool.__weikuan_refund_apply_key, order_id)

    @staticmethod
    def get_weikuan_refund_applay_orders():
        return list(redis_client.smembers(RefundTool.__weikuan_refund_apply_key))

    @staticmethod
    def add_weikuan_refund_success_order(order_id):
        redis_client.sadd(RefundTool.__weikuan_success_key, order_id)

    @staticmethod
    def get_weikuan_refund_fial_orders():
        return list(redis_client.sdiff(RefundTool.__weikuan_refund_apply_key, RefundTool.__weikuan_success_key))

    @staticmethod
    def clear_all():
        redis_client.delete(RefundTool.__refund_apply_key)
        redis_client.delete(RefundTool.__refund_success_key)
        redis_client.delete(RefundTool.__weikuan_refund_apply_key)
        redis_client.delete(RefundTool.__weikuan_success_key)

    @staticmethod
    def now_time():
        fmt = '%Y-%m-%d %H:%M:%S'
        timestamp = int(time.time())
        return time.strftime(fmt, time.localtime(timestamp))

    @staticmethod
    def do_refund_fial_orders():
        order_ids = RefundTool.get_refund_fial_orders()
        for order_id in order_ids:
            RefundTool.do_refund(order_id)
            time.sleep(1)
            print '------continue------'


    @staticmethod
    def do_refund(order_id):
        try:
            print '退款开始:{0}'.format(order_id)
            res = ctx.gaia_local['pay/unified/refund'](order_id=order_id).unwrap()
            print '退款完成:{0}--{1}'.format(order_id, json.dumps(res, ensure_ascii=False))
        except Exception as e:
            print '退款出错:{0}--{1}'.format(order_id, str(e))


