# coding=utf-8
import datetime


def get_current_time(time_format=None):
    now = datetime.datetime.now()
    if time_format:
        now = now.strftime(time_format)
    return now


def get_timestamp_epoch(the_time):
    if the_time is None:
        return None

    if isinstance(the_time, datetime.datetime):
        pass
    elif isinstance(the_time, datetime.date):
        # TODO: 是这样算的么？
        the_time = datetime.datetime(the_time.year, the_time.month, the_time.day)
    else:
        raise TypeError("datetime.datetime or datetime.date expected. [%s]" % type(the_time))

    return int((the_time - datetime.datetime.utcfromtimestamp(0)).total_seconds())


def format_time(d_time, time_format=None):
    if not d_time:
        return ''
    if time_format:
        time_formated = d_time.strftime(time_format)
    else:
        time_formated = d_time.strftime("%Y-%m-%d %H:%M:%S")
    return time_formated
