from __future__ import absolute_import, unicode_literals
from django.db import models


# Create your models here.


class SMSTemplate(models.Model):
    class Meta:
        app_label = 'sms'

    content = models.CharField(max_length=500)

    def platform_template_id(self, platform):
        return self.items.get(platform=platform).template_id


class SMSTemplateItem(models.Model):
    class Meta:
        app_label = 'sms'

    sms_template = models.ForeignKey(SMSTemplate, related_name='items')
    template_id = models.CharField(max_length=20)
    platform = models.CharField(max_length=20)
