# coding=utf-8
from __future__ import unicode_literals, absolute_import

from rpc.decorators import bind_context
from social.models import UserFollow
from api.tool.user_tool import get_user_from_context
from social import SocialInfo


@bind_context('social/user/follow')
def user_relation(ctx, user_id, follow_id):
    try:
        relation = UserFollow.objects.get(user_id=user_id, follow_id=follow_id)
        if relation.bond:
            return {"followed":True}
        else:
            return {"followed":False}
    except UserFollow.DoesNotExist:
        return {"followed":False}


@bind_context('social/suozhang/push_topic_in_mailbox')
def push_topic_in_mailbox(ctx, id):
    return


@bind_context('social/user/user_follow_info')
def user_follow_info(ctx, user_ids):
    """
    获取用户关注关系
    :param user_ids: 用户ID列表
    :return:
    """
    user = get_user_from_context(ctx)
    if not user:
        return {}

    social_info = SocialInfo(uid=user.id)
    follow_info = social_info.is_following_users(uids=user_ids)

    return follow_info
