-- Deploy gaia:2019-12-11-add-newtag-3.0 to mysql

BEGIN;

CREATE TABLE `api_tag_attr` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `name` varchar(128) NOT NULL,
    `homoionym` varchar(1024),
    `aggregate_type` varchar(3) NOT NULL
) ROW_FORMAT=DYNAMIC;


CREATE TABLE `api_tag_attr_tag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `tag_attr_id` integer NOT NULL,
    `tag_id` integer NOT NULL
);

CREATE TABLE `api_tag_attr_synonym` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `tag_attr_id` integer NOT NULL,
    `name` varchar(128) NOT NULL
);

CREATE TABLE `api_tag_3_0` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `name` varchar(128) NOT NULL,
    `homoionym` varchar(1024),
    `is_display` bool NOT NULL
) ROW_FORMAT=DYNAMIC;

CREATE TABLE `api_tag_category` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `name` varchar(128) NOT NULL
);

CREATE TABLE `api_tag_category_tag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `tag_id` integer NOT NULL,
    `tag_category_id` integer NOT NULL
);

CREATE TABLE `api_tag_extra` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `aggregate_type` varchar(3) NOT NULL,
    `count` integer NOT NULL
);

CREATE TABLE `api_tag_map_oldtag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `tag_id` integer NOT NULL,
    `old_tag_id` integer NOT NULL
);

CREATE TABLE `api_tag_aggregate` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `name` varchar(128) NOT NULL,
    `tag_id` integer NOT NULL
);


CREATE INDEX `api_tag_attr_tag_b068931c` ON `api_tag_attr_tag` (`tag_attr_id`);
CREATE INDEX `api_tag_attr_tag_8de229d2` ON `api_tag_attr_tag` (`tag_id`);

CREATE INDEX `api_tag_attr_b068931c` ON `api_tag_attr` (`name`);
CREATE INDEX `api_tag_attr_8de229d2` ON `api_tag_attr` (`homoionym`);
CREATE INDEX `api_tag_attr_synonym_595fcee8` ON `api_tag_attr_synonym` (`tag_attr_id`);
CREATE INDEX `api_tag_attr_synonym_b068931c` ON `api_tag_attr_synonym` (`name`);
CREATE INDEX `api_tag_3_0_8de229d2` ON `api_tag_3_0` (`homoionym`);
CREATE INDEX `api_tag_category_b068931c` ON `api_tag_category` (`name`);
CREATE INDEX `api_tag_category_tag_76f094bc` ON `api_tag_category_tag` (`tag_id`);
CREATE INDEX `api_tag_category_tag_89df0f22` ON `api_tag_category_tag` (`tag_category_id`);
CREATE INDEX `api_tag_map_oldtag_76f094bc` ON `api_tag_map_oldtag` (`tag_id`);
CREATE INDEX `api_tag_map_oldtag_e85ff166` ON `api_tag_map_oldtag` (`old_tag_id`);
CREATE INDEX `api_tag_aggregate_b068931c` ON `api_tag_aggregate` (`name`);
CREATE INDEX `api_tag_aggregate_b147911c` ON `api_tag_aggregate` (`tag_id`);

COMMIT;
