-- Deploy gaia:2020-01-08-group to mysql

BEGIN;

CREATE TABLE `api_group` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(32) NOT NULL,
    `introduction` longtext NOT NULL,
    `header_image` varchar(255) NOT NULL,
    `bg_image` varchar(255) NOT NULL,
    `is_online` bool NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `create_time` datetime(6) NOT NULL
);

CREATE TABLE `api_group_content` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `content_type` integer NOT NULL,
    `content_id` integer NOT NULL,
    `group_id` integer NOT NULL,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
);

CREATE TABLE `api_group_follow` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `group_id` integer NOT NULL,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
);

CREATE TABLE `api_group_tag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `tag_id` integer NOT NULL,
    `group_id` integer NOT NULL,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
);

CREATE INDEX `api_group_content_e14f02ad` ON `api_group_content` (`content_id`);
CREATE INDEX `api_group_content_0e939a4f` ON `api_group_content` (`group_id`);
CREATE INDEX `api_group_follow_e8701ad4` ON `api_group_follow` (`user_id`);
CREATE INDEX `api_group_follow_0e939a4f` ON `api_group_follow` (`group_id`);
CREATE INDEX `api_group_tag_76f094bc` ON `api_group_tag` (`tag_id`);
CREATE INDEX `api_group_tag_d6993334` ON `api_group_tag` (`group_id`);

COMMIT;
