-- Deploy gaia:2020-04-16-726_group_topic to mysql

BEGIN;

CREATE TABLE `api_group_topic_relation` (
	`id` INTEGER AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`group_id` INTEGER NOT NULL,
	`topic_id` INTEGER NOT NULL,
	`rank` INTEGER NULL,
	`is_online` bool NOT NULL,
	`create_time` datetime ( 6 ) NOT NULL,
	`update_time` datetime ( 6 ) NOT NULL
);
CREATE TABLE `api_group_topic` (
	`id` INTEGER AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`name` VARCHAR ( 32 ) NOT NULL,
	`introduction` LONGTEXT NOT NULL,
	`header_image` VARCHAR ( 255 ) NOT NULL,
	`bg_image` VARCHAR ( 255 ) NOT NULL,
	`top_card_type`  VARCHAR ( 3 ) NULL,
	`top_card_id` INTEGER NULL,
	`punch_entrance` LONGTEXT NULL,
	`display_hit_rank` bool NOT NULL,
	`hit_rank_start_time` datetime ( 6 ) NULL,
	`hit_rank_end_time` datetime ( 6 ) NULL,
	`is_online` bool NOT NULL,
	`create_time` datetime ( 6 ) NOT NULL,
	`update_time` datetime ( 6 ) NOT NULL
);
CREATE TABLE `api_group_topic_content` (
	`id` INTEGER AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`is_online` bool NOT NULL,
	`create_time` datetime ( 6 ) NOT NULL,
	`update_time` datetime ( 6 ) NOT NULL,
	`content_type` INTEGER NOT NULL,
	`content_id` INTEGER NOT NULL,
	`topic_id` INTEGER NOT NULL
);
CREATE TABLE `api_group_topic_follow` (
	`id` INTEGER AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`is_online` bool NOT NULL,
	`create_time` datetime ( 6 ) NOT NULL,
	`update_time` datetime ( 6 ) NOT NULL,
	`user_id` INTEGER NOT NULL,
	`topic_id` INTEGER NOT NULL
);
CREATE TABLE `api_group_topic_tag` (
	`id` INTEGER AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`tag_id` INTEGER NOT NULL,
	`topic_id` INTEGER NOT NULL,
	`is_online` bool NOT NULL,
	`create_time` datetime ( 6 ) NOT NULL,
	`update_time` datetime ( 6 ) NOT NULL
);
CREATE TABLE `api_group_topic_tag_v3` (
	`id` INTEGER AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`topic_id` INTEGER NOT NULL,
	`tag_v3_id` INTEGER NOT NULL,
	`is_online` bool NOT NULL,
	`create_time` datetime ( 6 ) NOT NULL,
`update_time` datetime ( 6 ) NOT NULL
);

ALTER TABLE `api_group` ADD COLUMN `punch_entrance` longtext NULL;
ALTER TABLE `api_group` ADD COLUMN `top_card_id` integer NULL;
ALTER TABLE `api_group` ADD COLUMN `top_card_type`  VARCHAR ( 3 ) NULL;

ALTER TABLE `api_group_topic_relation` ADD CONSTRAINT `api_group_topic_relation_group_id_4c990f60ec0d97f1_uniq` UNIQUE (`group_id`, `topic_id`);
CREATE INDEX `api_group_topic_relation_19b4d727` ON `api_group_topic_relation` (`topic_id`);
CREATE INDEX `api_group_topic_content_e14f02ad` ON `api_group_topic_content` (`content_id`);
CREATE INDEX `api_group_topic_content_19b4d727` ON `api_group_topic_content` (`topic_id`);
CREATE INDEX `api_group_topic_follow_e8701ad4` ON `api_group_topic_follow` (`user_id`);
CREATE INDEX `api_group_topic_follow_19b4d727` ON `api_group_topic_follow` (`topic_id`);
CREATE INDEX `api_group_topic_tag_76f094bc` ON `api_group_topic_tag` (`tag_id`);
CREATE INDEX `api_group_topic_tag_19b4d727` ON `api_group_topic_tag` (`topic_id`);
CREATE INDEX `api_group_topic_tag_v3_19b4d727` ON `api_group_topic_tag_v3` (`topic_id`);
CREATE INDEX `api_group_topic_tag_v3_f08f66f7` ON `api_group_topic_tag_v3` (`tag_v3_id`);


COMMIT;
