-- Deploy gaia:2020-07-16_create_hot_table to mysql

BEGIN;

CREATE TABLE `api_hot` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(100) NOT NULL,
    `pic` varchar(255) NOT NULL,
    `sort_num` integer NOT NULL,
    `user_type` varchar(2) NOT NULL,
    `pay_type` varchar(2) NOT NULL,
    `is_online` bool NOT NULL,
    `topic` varchar(255),
    `new_topic` varchar(255),
    `begin_time` datetime,
    `offline_time` datetime,
    `channel` varchar(32),
    `create_at` datetime NOT NULL,
    `update_at` datetime NOT NULL
);

CREATE TABLE `api_hot_region` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `hot_id` integer NOT NULL,
    `region_id` integer NOT NULL,
    CONSTRAINT `fk_hot_region_hot_id` FOREIGN KEY (`hot_id`) REFERENCES `api_hot` (`id`),
    CONSTRAINT `fk_hot_region_region_id` FOREIGN KEY (`region_id`) REFERENCES `api_region` (`id`)
);

CREATE TABLE `api_hot_city` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `hot_id` integer NOT NULL,
    `city_id` varchar(40) NOT NULL,
    CONSTRAINT `fk_hot_city_hot_id` FOREIGN KEY (`hot_id`) REFERENCES `api_hot` (`id`),
    CONSTRAINT `fk_hot_city_city_id` FOREIGN KEY (`city_id`) REFERENCES `api_city` (`id`)
);

COMMIT;