-- Deploy gaia:20200309_add_feedback_question_answer to mysql

BEGIN;

-- XXX Add DDLs here.
CREATE TABLE `api_feedback_question` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mold` tinyint(4) NOT NULL DEFAULT '1' COMMENT '问题类型',
  `function` varchar(64) NOT NULL DEFAULT '' COMMENT '功能名称',
  `rank` tinyint(4) NOT NULL DEFAULT '1' COMMENT '问题等级',
  `title` varchar(256) NOT NULL DEFAULT '' COMMENT '内容title',
  `is_online` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否上线',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_api_feedback_question_is_online` (`is_online`),
  KEY `idx_api_feedback_question_function` (`function`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='反馈问题';

CREATE TABLE `api_feedback_answer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `question_id` int(11) NOT NULL COMMENT '问题id',
  `content` varchar(256) NOT NULL DEFAULT '' COMMENT '答案内容',
  `is_online` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否上线',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_api_feedback_answer_is_online` (`is_online`),
  KEY `idx_api_feedback_answer_question_id` (`question_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='反馈问题的选项';

CREATE TABLE `api_feedback_function_period` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `period` int(11) NOT NULL COMMENT '周期长度',
  `function` varchar(64) NOT NULL DEFAULT '' COMMENT '功能名称',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_api_feedback_function_period_function` (`function`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='功能反馈周期';

CREATE TABLE `api_feedback_user_submit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `device_id` varchar(64) NOT NULL COMMENT '设备id',
  `question_id` int(11) NOT NULL COMMENT '问题id',
  `answer_ids` varchar(128) NOT NULL DEFAULT '' COMMENT '答案id 列表, 逗号隔开',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_api_feedback_user_submit_device_id` (`device_id`),
  KEY `idx_api_feedback_user_submit_question_id` (`question_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户提交反馈结果';

CREATE TABLE `api_user_visit_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `device_id` varchar(64) NOT NULL COMMENT '设备id',
  `function` varchar(64) NOT NULL DEFAULT '' COMMENT '功能名称',
  `visit_times` int(11) NOT NULL DEFAULT '1' COMMENT '访问次数',
  `submit_times` int(11) NOT NULL DEFAULT '1' COMMENT '反馈提交次数',
  `last_visit_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_api_user_visit_record_device_id` (`device_id`),
  KEY `idx_api_user_visit_record_function` (`function`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='用户访问记录';

COMMIT;
