-- Deploy gaia:20200410-tag-map-tag to mysql

BEGIN;

CREATE TABLE `api_tag_map_tag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `related_tag_id` integer NOT NULL,
    `tag_id` integer NOT NULL
);

CREATE TABLE `api_tag_attr_relation` (
        `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
        `child_id` integer NOT NULL,
        `parent_id` integer NOT NULL,
        `create_time` datetime(6) NOT NULL,
        `update_time` datetime(6) NOT NULL,
        `is_online` bool NOT NULL,
        UNIQUE (`parent_id`, `child_id`)
        );

ALTER TABLE `api_tag_attr` ADD COLUMN `sub_attr_type` varchar(3) NOT NULL DEFAULT '0';

CREATE INDEX `tag_id` ON `api_tag_map_tag` (`tag_id`);
CREATE INDEX `related_tag_id` ON `api_tag_map_tag` (`related_tag_id`);

CREATE INDEX `child_id` ON `api_tag_attr_relation` (`child_id`);

COMMIT;
