-- Deploy gaia:20200722_creare_plastics_3_0 to mysql

BEGIN;

-- XXX Add DDLs here.

CREATE TABLE `user_plastic_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url_key` varchar(32) NOT NULL COMMENT 'url 关键字',
  `image_url` varchar(512) NOT NULL COMMENT '图片地址',
  `megvii_landmark` Text COMMENT '旷视landmark',
  `byte_dance_landmark` Text COMMENT '字节landmark',
  `gold_values` Text COMMENT '计算出的所有美学值',
  `proportion` Text COMMENT '计算出的关键美学值',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_user_plastic_history_url_key` (`url_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户模拟整形历史';



CREATE TABLE `user_cheek_types_feasibility` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cheek_style_id` INT(11) NOT NULL COMMENT '风格脸id',
  `user_plastic_history_id` INT(11) NOT NULL COMMENT '用户模拟整形历史id',
  `feasibility_info` Text COMMENT '风格脸可行性值，计算出来的json',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_uctf_id_cheek_style_id` (`user_plastic_history_id`, `cheek_style_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户风格脸可行性值';

COMMIT;
