-- Deploy gaia:ai_qa to mysql

BEGIN;

CREATE TABLE `api_ai_qa_answer` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `title` varchar(1024) NOT NULL,
    `is_online` bool NOT NULL,
    `image_url` varchar(256) NOT NULL,
    `color` varchar(20) NOT NULL
);

CREATE TABLE `api_ai_qa_answer_tag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `ai_answer_id` integer NOT NULL,
    `tag_id` integer NOT NULL
);

CREATE TABLE `api_ai_qa_message` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `group_id` varchar(128) NOT NULL,
    `user_id` integer NOT NULL,
    `ass_uid` integer NOT NULL,
    `msg` varchar(1024) NOT NULL,
    `type` integer NOT NULL,
    `ident` varchar(128) NOT NULL,
    `data` varchar(1024) NOT NULL,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `last_modified` datetime(6) NOT NULL
);

CREATE TABLE `api_ai_qa_message_group` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `group_id` varchar(128) NOT NULL,
    `user_id` integer NOT NULL,
    `ass_uid` integer NOT NULL,
    `finished` bool NOT NULL,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `last_modified` datetime(6) NOT NULL
);


CREATE TABLE `api_ai_qa_question` (
	`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`title` varchar(128) NOT NULL,
	`question_type` integer NOT NULL
);

CREATE TABLE `api_ai_qa_question_answer` (
	`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`ai_question_id` integer NOT NULL,
	`ai_answer_id` integer NOT NULL,
	`rank` integer NOT NULL,
	`next_type` integer NOT NULL,
	`relation_data` longtext NOT NULL
);

CREATE TABLE `api_ai_qa_follow_question_group` (
	`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`title` varchar(128) NOT NULL,
	`content` longtext NOT NULL,
	`is_online` bool NOT NULL,
	`create_time` datetime(6) NOT NULL,
	`update_time` datetime(6) NOT NULL,
	`last_modified` datetime(6) NOT NULL
);

CREATE TABLE `api_ai_qa_recommend` (
	`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`title` varchar(128) NOT NULL,
	`desc` varchar(1024) NOT NULL,
	`url` varchar(256) NOT NULL,
	`is_online` bool NOT NULL,
	`create_time` datetime(6) NOT NULL,
	`update_time` datetime(6) NOT NULL,
	`last_modified` datetime(6) NOT NULL
);

CREATE TABLE `api_ai_qa_theme` (
	`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`title` longtext NOT NULL,
	`is_online` bool NOT NULL,
    `ass_uid` integer NOT NULL,
	`first_welcome_contents` longtext NOT NULL,
	`redo_welcome_contents` longtext NOT NULL,
	`conclusion` longtext NOT NULL,
	`entrance_question_id` integer NOT NULL,
	`create_time` datetime(6) NOT NULL,
	`update_time` datetime(6) NOT NULL,
	`last_modified` datetime(6) NOT NULL
);


CREATE INDEX `api_ai_qa_answer_tag_40fb15f6` ON `api_ai_qa_answer_tag` (`ai_answer_id`);
CREATE INDEX `api_ai_qa_answer_tag_76f094bc` ON `api_ai_qa_answer_tag` (`tag_id`);
CREATE INDEX `api_ai_qa_message_0e939a4f` ON `api_ai_qa_message` (`group_id`);
CREATE INDEX `api_ai_qa_message_e8701ad4` ON `api_ai_qa_message` (`user_id`);
CREATE INDEX `api_ai_qa_message_00644510` ON `api_ai_qa_message` (`ass_uid`);
CREATE INDEX `api_ai_qa_message_group_0e939a4f` ON `api_ai_qa_message_group` (`group_id`);
CREATE INDEX `api_ai_qa_message_group_e8701ad4` ON `api_ai_qa_message_group` (`user_id`);
CREATE INDEX `api_ai_qa_message_group_00644510` ON `api_ai_qa_message_group` (`ass_uid`);
CREATE INDEX `api_ai_qa_question_answer_18c2f0c1` ON `api_ai_qa_question_answer` (`ai_question_id`);
CREATE INDEX `api_ai_qa_question_answer_40fb15f6` ON `api_ai_qa_question_answer` (`ai_answer_id`);
CREATE INDEX `api_ai_qa_theme_869510f6` ON `api_ai_qa_theme` (`entrance_question_id`);

COMMIT;
