-- Deploy gaia:api_2016_10_12_create_table_api_tickets to mysql

BEGIN;

CREATE TABLE `api_ticketsresult` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `doctor_id` varchar(100) NOT NULL UNIQUE,
    `start_sink` datetime(6),
    `end_sink` datetime(6),
    `sink_days` integer
)
;
ALTER TABLE `api_ticketsresult` ADD CONSTRAINT `doctor_id_refs_id_9f79c10d` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);

CREATE TABLE `api_tickets` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `doctor_id` varchar(100) NOT NULL,
    `tickets_time` datetime(6) NOT NULL,
    `status` varchar(8) NOT NULL,
    `is_valid` bool NOT NULL,
    `tickets_result_id` integer
)
;
ALTER TABLE `api_tickets` ADD CONSTRAINT `doctor_id_refs_id_713f34e2` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
ALTER TABLE `api_tickets` ADD CONSTRAINT `tickets_result_id_refs_id_29835b48` FOREIGN KEY (`tickets_result_id`) REFERENCES `api_ticketsresult` (`id`);

CREATE TABLE `api_ticketsresultrecord` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `tickets_result_id` integer NOT NULL,
    `start_sink` datetime(6),
    `end_sink` datetime(6)
)
;
ALTER TABLE `api_ticketsresultrecord` ADD CONSTRAINT `tickets_result_id_refs_id_d7638d76` FOREIGN KEY (`tickets_result_id`) REFERENCES `api_ticketsresult` (`id`);

CREATE TABLE `api_ticketsresultdetail` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `tickets_result_id` integer NOT NULL,
    `start_sink` datetime(6),
    `end_sink` datetime(6),
    `sink_days` integer,
    `tickets_list` longtext NOT NULL,
    `service_list` longtext NOT NULL,
    `user_id` integer NOT NULL,
    `created_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_ticketsresultdetail` ADD CONSTRAINT `tickets_result_id_refs_id_0e84f51e` FOREIGN KEY (`tickets_result_id`) REFERENCES `api_ticketsresult` (`id`);
ALTER TABLE `api_ticketsresultdetail` ADD CONSTRAINT `user_id_refs_id_3bc25fc8` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);

ALTER TABLE `api_singlerecord` ADD COLUMN `create_user_id` INTEGER;
ALTER TABLE `api_singlerecord` ADD COLUMN `order_id` VARCHAR (12);
ALTER TABLE `api_singlerecord` ADD COLUMN `is_revoke` bool Not NULL DEFAULT FALSE ;
ALTER TABLE `api_singlerecord` ADD COLUMN `tickets_id` INTEGER;
ALTER TABLE `api_singlerecord` ADD COLUMN `tickets_time` datetime(6);

ALTER TABLE `api_singlerecord` ADD CONSTRAINT `create_user_id_refs_id_4dd58695` FOREIGN KEY (`create_user_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_singlerecord` ADD CONSTRAINT `tickets_id_refs_id_d5905384` FOREIGN KEY (`tickets_id`) REFERENCES `api_tickets` (`id`);
ALTER TABLE `api_singlerecord` ADD CONSTRAINT `order_id_refs_id_b4f31fde` FOREIGN KEY (`order_id`) REFERENCES `api_order` (`id`);

ALTER TABLE `api_service` ADD COLUMN `tickets_result_id` INTEGER;
ALTER TABLE `api_service` ADD CONSTRAINT `tickets_result_id_refs_id_082fc5cb` FOREIGN KEY (`tickets_result_id`) REFERENCES `api_ticketsresult` (`id`);

COMMIT;
