-- Deploy gaia:api_2017_06_28_multitopic to mysql

BEGIN;

CREATE TABLE `api_multitopic` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `multitopic_type` varchar(2) NOT NULL,
    `service_type` varchar(1) NOT NULL,
    `topic_id` integer,
    `service_id` integer,
    `diary_id` integer,
    `url` varchar(1024),
    `ordering` integer NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `effect_time` datetime(6),
    `end_time` datetime(6),
    `is_online` bool NOT NULL,
    `tag_id` integer,
    `special_id` integer,
    `activity_id` integer,
    `title` varchar(100),
    `zhiboconfig_id` integer,
    `question_id` integer
);
ALTER TABLE `api_multitopic` ADD CONSTRAINT `question_id_refs_id_f65d723e` FOREIGN KEY (`question_id`) REFERENCES `api_question` (`id`);
ALTER TABLE `api_multitopic` ADD CONSTRAINT `activity_id_refs_id_9e49932d` FOREIGN KEY (`activity_id`) REFERENCES `api_activity` (`id`);
ALTER TABLE `api_multitopic` ADD CONSTRAINT `zhiboconfig_id_refs_id_dca02498` FOREIGN KEY (`zhiboconfig_id`) REFERENCES `api_zhiboconfig` (`id`);
ALTER TABLE `api_multitopic` ADD CONSTRAINT `diary_id_refs_id_c263d948` FOREIGN KEY (`diary_id`) REFERENCES `api_diary` (`id`);
ALTER TABLE `api_multitopic` ADD CONSTRAINT `topic_id_refs_id_65f0e65e` FOREIGN KEY (`topic_id`) REFERENCES `api_problem` (`id`);
ALTER TABLE `api_multitopic` ADD CONSTRAINT `service_id_refs_id_ae2596be` FOREIGN KEY (`service_id`) REFERENCES `api_service` (`id`);
ALTER TABLE `api_multitopic` ADD CONSTRAINT `special_id_refs_id_76dc5fa1` FOREIGN KEY (`special_id`) REFERENCES `api_special` (`id`);
ALTER TABLE `api_multitopic` ADD CONSTRAINT `tag_id_refs_id_af91e60a` FOREIGN KEY (`tag_id`) REFERENCES `api_tag` (`id`);

CREATE TABLE `api_zonewhitelist` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `zone_id` integer NOT NULL,
    `is_online` bool NOT NULL
);
ALTER TABLE `api_zonewhitelist` ADD CONSTRAINT `zone_id_refs_id_bffd19e5` FOREIGN KEY (`zone_id`) REFERENCES `api_zone` (`id`);

CREATE TABLE `api_multitopicreview` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `content_id` varchar(10) NOT NULL,
    `content_type` varchar(1) NOT NULL,
    `status` varchar(1) NOT NULL
);

COMMIT;
