-- Deploy gaia:hippo_20171103_billtable to mysql

BEGIN;

CREATE TABLE `hippo_financeinfo` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `tax_id` varchar(40) NOT NULL,
    `register_address` varchar(50) NOT NULL,
    `register_phone` varchar(50) NOT NULL,
    `account_name` varchar(50) NOT NULL,
    `bank_account` varchar(50) NOT NULL,
    `receiver_name` varchar(40) NOT NULL,
    `receiver_phone` varchar(40) NOT NULL,
    `receiver_address` varchar(100) NOT NULL,
    `doctor_id` varchar(100) NOT NULL UNIQUE
);
ALTER TABLE `hippo_financeinfo` ADD CONSTRAINT `doctor_id_refs_id_89125270` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
CREATE TABLE `hippo_billapplyrecord` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `created_time` datetime(6) NOT NULL,
    `bill_time` datetime(6),
    `amount` integer NOT NULL,
    `bill_type` integer NOT NULL,
    `status` integer NOT NULL,
    `express_company` integer,
    `express_id` varchar(100),
    `snapshot` varchar(2000) NOT NULL,
    `reason` integer NOT NULL,
    `doctor_id` varchar(100) NOT NULL
);
ALTER TABLE `hippo_billapplyrecord` ADD CONSTRAINT `doctor_id_refs_id_53f90dc7` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
CREATE TABLE `hippo_billidtobillapply` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `billapplyrecord_id` integer NOT NULL,
    `bill_id` varchar(50) NOT NULL
);
ALTER TABLE `hippo_billidtobillapply` ADD CONSTRAINT `billapplyrecord_id_refs_id_d2a4b322` FOREIGN KEY (`billapplyrecord_id`) REFERENCES `hippo_billapplyrecord` (`id`);
CREATE TABLE `hippo_billtostatementall` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `billapplyrecord_id` integer NOT NULL,
    `statementall_id` varchar(15) NOT NULL,
    `created_time` datetime(6) NOT NULL
);
ALTER TABLE `hippo_billtostatementall` ADD CONSTRAINT `billapplyrecord_id_refs_id_331cf502` FOREIGN KEY (`billapplyrecord_id`) REFERENCES `hippo_billapplyrecord` (`id`);
ALTER TABLE `hippo_billtostatementall` ADD CONSTRAINT `statementall_id_refs_id_c4e42c27` FOREIGN KEY (`statementall_id`) REFERENCES `pay_statementall` (`id`);

COMMIT;
