-- Deploy gaia:launch_2019_12_10_create_table to mysql

BEGIN;

-- XXX Add DDLs here.
CREATE TABLE `api_questionnaire_theme` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `theme` longtext NOT NULL,
    `operator_id` integer NOT NULL,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `last_modified` datetime(6) NOT NULL
);
ALTER TABLE `api_questionnaire_theme` ADD CONSTRAINT `operator_id_refs_id_9ec84e23` FOREIGN KEY (`operator_id`) REFERENCES `auth_user` (`id`);

CREATE TABLE `api_questionnaire_question` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `questionnaire_theme_id` integer NOT NULL,
    `title` varchar(128) NOT NULL,
    `problem_type` integer NOT NULL,
    `relation_question_id` integer default 0,
    `rank` integer NOT NULL,
    `is_effect` bool NOT NULL,
    `is_delete` bool NOT NULL,
    `is_influence_user_portrait` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
);
ALTER TABLE `api_questionnaire_question` ADD CONSTRAINT `questionnaire_theme_id_refs_id_5354aeda` FOREIGN KEY (`questionnaire_theme_id`) REFERENCES `api_questionnaire_theme` (`id`);

CREATE TABLE `api_questionnaire_answer` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `questionnaire_question_id` integer NOT NULL,
    `questionnaire_content` varchar(128) NOT NULL,
    `questionnaire_image_url` varchar(256) NOT NULL,
    `answer_create_content` longtext NOT NULL,
    `answer_create_image_url` varchar(256) NOT NULL,
    `relation_question_id` integer default 0,
    `is_delete` bool NOT NULL,
    `is_ugc` bool NOT NULL,
    `rank` integer NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
);
ALTER TABLE `api_questionnaire_answer` ADD CONSTRAINT `questionnaire_question_id_refs_id_e64a5250` FOREIGN KEY (`questionnaire_question_id`) REFERENCES `api_questionnaire_question` (`id`);

CREATE TABLE `api_questionnaire_answer_relation_tag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `questionnaire_answer_id` integer NOT NULL,
    `tag_id` integer NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
);
ALTER TABLE `api_questionnaire_answer_relation_tag` ADD CONSTRAINT `tag_id_refs_id_e87110b9` FOREIGN KEY (`tag_id`) REFERENCES `api_tag` (`id`);
ALTER TABLE `api_questionnaire_answer_relation_tag` ADD CONSTRAINT `questionnaire_answer_id_refs_id_c0340e1e` FOREIGN KEY (`questionnaire_answer_id`) REFERENCES `api_questionnaire_answer` (`id`);

CREATE INDEX `api_questionnaire_theme_5e7ba3ec` ON `api_questionnaire_theme` (`operator_id`);
CREATE INDEX `api_questionnaire_question_0ca366c7` ON `api_questionnaire_question` (`questionnaire_theme_id`);
CREATE INDEX `api_questionnaire_answer_6edd9e0b` ON `api_questionnaire_answer` (`questionnaire_question_id`);
CREATE INDEX `api_questionnaire_answer_relation_tag_8e5148db` ON `api_questionnaire_answer_relation_tag` (`questionnaire_answer_id`);
CREATE INDEX `api_questionnaire_answer_relation_tag_5659cca2` ON `api_questionnaire_answer_relation_tag` (`tag_id`);

COMMIT;
