-- Deploy gaia:launch_2020_01_09_create_table to mysql

BEGIN;

-- XXX Add DDLs here.
ALTER TABLE `api_questionnaire_answer` add COLUMN `is_force_display` bool NOT NULL DEFAULT False;
ALTER TABLE `api_questionnaire_answer` DROP FOREIGN KEY `questionnaire_question_id_refs_id_e64a5250`;

CREATE TABLE `api_questionnaire_questions` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `title` varchar(128) NOT NULL,
    `problem_type` integer NOT NULL,
    `relation_question_id` integer NOT NULL,
    `is_effect` bool NOT NULL,
    `is_delete` bool NOT NULL,
    `is_influence_user_portrait` bool NOT NULL,
    `is_filter_selected_answer` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
);

CREATE TABLE `api_questionnaire_theme_and_question_relations` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `questionnaire_theme_id` integer NOT NULL,
    `questionnaire_question_id` integer NOT NULL,
    `can_skip` bool NOT NULL,
    `rank` integer NOT NULL
);

CREATE TABLE `api_questionnaire_qa_sub_relations` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `questionnaire_theme_id` integer NOT NULL,
    `questionnaire_question_id` integer NOT NULL,
    `questionnaire_answer_id` integer NOT NULL,
    `questionnaire_sub_question_id` integer NOT NULL,
    `weight` integer NOT NULL,
    `can_skip` bool NOT NULL
);

CREATE INDEX `api_questionnaire_theme_and_question_relations_87102cd0` ON `api_questionnaire_theme_and_question_relations` (`questionnaire_theme_id`);
CREATE INDEX `api_questionnaire_theme_and_question_relations_390e9534` ON `api_questionnaire_theme_and_question_relations` (`questionnaire_question_id`);
CREATE INDEX `api_questionnaire_qa_sub_relations_87102cd0` ON `api_questionnaire_qa_sub_relations` (`questionnaire_theme_id`);
CREATE INDEX `api_questionnaire_qa_sub_relations_390e9534` ON `api_questionnaire_qa_sub_relations` (`questionnaire_question_id`);
CREATE INDEX `api_questionnaire_qa_sub_relations_52f3e0fd` ON `api_questionnaire_qa_sub_relations` (`questionnaire_answer_id`);
CREATE INDEX `api_questionnaire_qa_sub_relations_f56dfe03` ON `api_questionnaire_qa_sub_relations` (`questionnaire_sub_question_id`);

COMMIT;
