-- Deploy gaia:mark_2020_04_15_init_create_table to mysql

BEGIN;

-- XXX Add DDLs here.
CREATE TABLE `api_mark_activity` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `solid_title` varchar(512) NOT NULL,
    `hollow_title` varchar(512) NOT NULL
);

CREATE TABLE `api_mark_activity_rel_tag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `mark_activity_id` integer NOT NULL,
    `tag_id` integer NOT NULL
);

CREATE TABLE `api_mark_fortune_configs` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `mark_activity_id` integer NOT NULL,
    `skin_trait_id` integer NOT NULL,
    `title` varchar(512) NOT NULL,
    `constellation` varchar(12) NOT NULL,
    `blood_type` varchar(12) NOT NULL,
    `notes` longtext NOT NULL,
    `fitting_and_dread` longtext NOT NULL
);

CREATE TABLE `api_mark_log` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `device_id` varchar(128) NOT NULL,
    `skin_result_id` integer NOT NULL,
    `skin_data_source` varchar(12) NOT NULL,
    `mark_activity_id` integer NOT NULL,
    `mark_fortune_id` integer NOT NULL,
    `mark_date` date NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
);

CREATE TABLE `api_mark_log_statistic` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `device_id` varchar(128) NOT NULL,
    `mark_activity_id` integer NOT NULL,
    `mark_date` date NOT NULL,
    `daily_check_nums` integer NOT NULL
);

CREATE INDEX `api_mark_activity_rel_tag_4434e71f` ON `api_mark_activity_rel_tag` (`mark_activity_id`);
CREATE INDEX `api_mark_activity_rel_tag_9722465e` ON `api_mark_activity_rel_tag` (`tag_id`);
CREATE INDEX `api_mark_fortune_configs_4434e71f` ON `api_mark_fortune_configs` (`mark_activity_id`);
CREATE INDEX `api_mark_fortune_configs_c5c3ca7b` ON `api_mark_fortune_configs` (`skin_trait_id`);
CREATE INDEX `api_mark_log_1ffdedc6` ON `api_mark_log` (`user_id`);
CREATE INDEX `api_mark_log_6d993ecb` ON `api_mark_log` (`device_id`);
CREATE INDEX `api_mark_log_d11e8b3a` ON `api_mark_log` (`skin_result_id`);
CREATE INDEX `api_mark_log_4434e71f` ON `api_mark_log` (`mark_activity_id`);
CREATE INDEX `api_mark_log_b4d8a188` ON `api_mark_log` (`mark_date`);
CREATE INDEX `api_mark_log_statistic_1ffdedc6` ON `api_mark_log_statistic` (`user_id`);
CREATE INDEX `api_mark_log_statistic_6d993ecb` ON `api_mark_log_statistic` (`device_id`);
CREATE INDEX `api_mark_log_statistic_4434e71f` ON `api_mark_log_statistic` (`mark_activity_id`);
CREATE INDEX `api_mark_log_statistic_b4d8a188` ON `api_mark_log_statistic` (`mark_date`);

COMMIT;
