-- Deploy gaia:user_ground_push to mysql

BEGIN;

-- 活动中 用户分享码记录表
CREATE TABLE `api_usersharecode` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_online` tinyint(1) NOT NULL,
  `create_time` datetime(6) NOT NULL,
  `update_time` datetime(6) NOT NULL,
  `is_deleted` tinyint(1) NOT NULL,
  `user_id` int(11) NOT NULL,
  `start_time` datetime(6) NOT NULL,
  `end_time` datetime(6) NOT NULL,
  `share_code` varchar(20) NOT NULL COMMENT '邀请码',
  `code_type` int(11) NOT NULL COMMENT '邀请码类型, 活动类型',
  PRIMARY KEY (`id`),
  KEY `user_id_foreign_to_user` (`user_id`),
  KEY `start_time_idx` (`start_time`),
  KEY `end_time_idx` (`end_time`),
  KEY `share_code_type` (`share_code`,`code_type`),
  CONSTRAINT `user_id_foreign_to_user` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 第三方信息记录
CREATE TABLE `api_thirdrecord` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_online` tinyint(1) NOT NULL,
  `create_time` datetime(6) NOT NULL,
  `update_time` datetime(6) NOT NULL,
  `is_deleted` tinyint(1) NOT NULL,
  `platform_id` varchar(60) NOT NULL,
  `nickname` varchar(255) NOT NULL,
  `imgurl` varchar(255) NOT NULL,
  `city` varchar(255) NULL,
  `activity_type` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `thirdrecord_pid` (`platform_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 活动中 用户展示信息表
CREATE TABLE `api_usershowinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_online` tinyint(1) NOT NULL,
  `create_time` datetime(6) NOT NULL,
  `update_time` datetime(6) NOT NULL,
  `is_deleted` tinyint(1) NOT NULL,
  `user_id` int(11) NOT NULL,
  `activity_type` int(11) NOT NULL,
  `thirdrecord_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `update_time_idx` (`update_time`),
  KEY `user_id_foreign_to_user_idx` (`user_id`),
  KEY `showinfo_update_time_idx` (`update_time`),
  KEY `showinfo_user_id_foreign_to_user_idx` (`user_id`),
  KEY `showinfo_foreign_to_thridcord_idx` (`thirdrecord_id`),
  CONSTRAINT `showinfo_foreign_to_thridcord` FOREIGN KEY (`thirdrecord_id`) REFERENCES `api_thirdrecord` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `showinfo_foreign_to_user` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 活动中 用户邀请关系表
CREATE TABLE `api_userinvite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_online` tinyint(1) NOT NULL,
  `create_time` datetime(6) NOT NULL,
  `update_time` datetime(6) NOT NULL,
  `is_deleted` tinyint(1) NOT NULL,
  `inviter_id` int(11) NOT NULL,
  `invitee_id` int(11) NOT NULL,
  `invite_status` int(11) NOT NULL,
  `acvitity_type` int(11) NOT NULL,
  `share_code` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `userinvite_ter_foreign_to_user_idx` (`inviter_id`),
  KEY `userinvite_tee_foreign_to_user_idx` (`invitee_id`),
  KEY `userinvite_update_timeidx` (`update_time`),
  CONSTRAINT `userinvite_ter_foreign_to_user` FOREIGN KEY (`inviter_id`) REFERENCES `auth_user` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `userinvite_tee_foreign_to_user` FOREIGN KEY (`invitee_id`) REFERENCES `auth_user` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 活动奖励 用户兑换记录表
CREATE TABLE `api_userexchange` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_online` tinyint(1) NOT NULL,
  `create_time` datetime(6) NOT NULL,
  `update_time` datetime(6) NOT NULL,
  `is_deleted` tinyint(1) NOT NULL,
  `user_id` int(11) NOT NULL,
  `activity_type` int(11) NOT NULL,
  `exchange_status` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `userexchange_foreign_to_user_idx` (`user_id`),
  KEY `userexchange_update_timeidx` (`update_time`),
  CONSTRAINT `userexchange_foreign_to_user` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


COMMIT;
