-- Deploy gaia:variety_show_2020_05_22_create_young_related_table to mysql

BEGIN;

-- XXX Add DDLs here.
CREATE TABLE `api_young_base_info` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `start_time` datetime(6) NOT NULL,
    `end_time` datetime(6) NOT NULL,
    `rule` longtext NOT NULL
)
;
CREATE TABLE `api_young_tag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `young_id` integer NOT NULL,
    `tag_id` integer NOT NULL
)
;
CREATE TABLE `api_young_idol` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `name` varchar(32) NOT NULL,
    `image` varchar(255) NOT NULL,
    `group_id` integer,
    `is_out` integer NOT NULL DEFAULT 0,
    `real_votes` integer NOT NULL DEFAULT 0,
    `fake_votes` integer NOT NULL DEFAULT 0,
    `hera_votes` integer NOT NULL DEFAULT 0
)
;
CREATE TABLE `api_young_vote_record` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `user_id` integer NOT NULL,
    `idol_id` integer NOT NULL,
    `vote_date` date NOT NULL,
    `votes` integer NOT NULL DEFAULT 0,
    `is_fake` bool NOT NULL DEFAULT 0
)
;
CREATE TABLE `api_young_invite_code` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `user_id` integer NOT NULL,
    `invite_code` varchar(20) NOT NULL
)
;
CREATE TABLE `api_young_invite_record` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `user_id` integer NOT NULL,
    `invited_user_id` integer NOT NULL,
    `task_record_id` integer NOT NULL
)
;
CREATE TABLE `api_young_task_record` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `user_id` integer NOT NULL,
    `task_type` integer NOT NULL,
    `done_date` date NOT NULL,
    `is_valid` bool NOT NULL
)
;
CREATE TABLE `api_young_task_config` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `new_special_id` integer NOT NULL,
    `group_special_id` integer NOT NULL
)
;
CREATE INDEX `api_young_vote_record_1ffdedc6` ON `api_young_vote_record` (`user_id`);
CREATE INDEX `api_young_vote_record_bc6c2fe3` ON `api_young_vote_record` (`vote_date`);
CREATE INDEX `api_young_invite_code_1ffdedc6` ON `api_young_invite_code` (`user_id`);
CREATE INDEX `api_young_invite_code_3ad8b48e` ON `api_young_invite_code` (`invite_code`);
CREATE INDEX `api_young_invite_record_a9012dd5` ON `api_young_invite_record` (`invited_user_id`);
CREATE INDEX `api_young_task_record_1ffdedc6` ON `api_young_task_record` (`user_id`);
CREATE INDEX `api_young_task_record_81e9ffef` ON `api_young_task_record` (`done_date`);

COMMIT;
