# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function

import math
from .basic import LiteralType


class None_(LiteralType):

    def contains(self, item):
        return item is None

    def to_python(self):
        return None


class True_(LiteralType):

    def contains(self, item):
        return item is True

    def to_python(self):
        return True


class False_(LiteralType):

    def contains(self, item):
        return item is False

    def to_python(self):
        return False


class Integer(LiteralType):

    def __init__(self, value):
        assert isinstance(value, (int, long))
        self._value = long(value)

    def contains(self, item):
        assert isinstance(item, (int, long))
        return item == self._value

    def to_python(self):
        return self._value


class Real(LiteralType):

    def __init__(self, value):
        assert isinstance(value, (int, long, float))
        assert not math.isnan(value)
        assert not math.isinf(value)
        self._value = float(value)

    def contains(self, item):
        assert isinstance(item, (int, long, float))
        return item == self._value

    def to_python(self):
        return self._value


class String(LiteralType):

    def __init__(self, value):
        assert isinstance(value, (str, unicode))
        self._value = unicode(value)

    def contains(self, item):
        assert isinstance(item, (str, unicode))
        return item == self._value

    def to_python(self):
        return self._value
