# coding=utf-8
from __future__ import absolute_import, unicode_literals, print_function

from talos.models.topic import Problem, PgcClassify, TopicReply, TopicScore
from graphene_django import DjangoObjectType
import graphene
from gql.types.gaia import *
from gmgql import RemoteFKField
from ..utils import gaia_gql_call


class ProblemType(DjangoObjectType):
    class Meta:
        model = Problem

    vote_amount = graphene.Field(graphene.Int)
    user = RemoteFKField(UserType, fk_model=Problem, fk_field_name='user_id',
                         remote_func=gaia_gql_call, remote_list_api_field='users')

    def resolve_vote_amount(self, *args, **kwargs):
        return self.vote_amount


class PgcClassifyType(DjangoObjectType):
    class Meta:
        model = PgcClassify


class TopicReplyType(DjangoObjectType):
    class Meta:
        model = TopicReply


class TopicScoreType(DjangoObjectType):
    class Meta:
        model = TopicScore
