# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models

from talos.services.tag import TagService

from .diary import Diary


class DiaryTag(models.Model):
    class Meta:
        app_label = 'talos'
        db_table = 'api_diary_tags'

    diary = models.ForeignKey(Diary)
    tag_id = models.IntegerField()

    def __unicode__(self):
        return "%s:%d" % (self.tag_id, self.diary_id)


class DiaryTagV3(models.Model):
    class Meta:
        db_table = 'api_diary_tag_v3'
        app_label = "talos"

    diary_id = models.IntegerField(verbose_name="日记本id", db_index=True)
    tag_v3_id = models.IntegerField(verbose_name="标签V3", db_index=True)
