# coding=utf-8

import json

# TODO zhangyunyu mv this cache
from rpc.cache import recommend_cache


class RecommendZoneDeploy(object):
    """
    首页推荐圈子配置
    """
    RKEY_PREFIX = 'recommend_zone'
    DEFAULT_DEPLOY = []

    @classmethod
    def _gen_key(cls):
        return '{}:{}'.format('recommend', cls.RKEY_PREFIX)

    @classmethod
    def set(cls, deploy_info):
        rkey = cls._gen_key()
        recommend_cache.set(rkey, json.dumps(deploy_info))

    @classmethod
    def get(cls):
        rkey = cls._gen_key()
        try:
            res = recommend_cache.get(rkey)
            if not res:
                res = cls.DEFAULT_DEPLOY
            else:
                res = json.loads(res)
            return res
        except:
            return cls.DEFAULT_DEPLOY
