#!/usr/bin/env python
# coding=utf-8

from gm_types.gaia import (FILTER_WORD_TYPE)

from talos.backbone.rpc import bind, cache_page
from talos.models.report import FilterWord
from talos.services import UserService

get_user_from_context = UserService.get_user_from_context


@bind('talos/filterWord/list')
@cache_page(5 * 60)
def get_filtered_words(filter_type=None):

    words = []
    if filter_type is None:
        words = FilterWord.objects.filter(is_filter=True).values_list('word', flat=True)

    elif filter_type == FILTER_WORD_TYPE.USER_NAME:
        words = FilterWord.objects.filter(is_filter=True, in_user_name=True).values_list('word', flat=True)

    elif filter_type == FILTER_WORD_TYPE.TOPIC_CONTENT:
        words = FilterWord.objects.filter(is_filter=True, in_topic_content=True).values_list('word', flat=True)

    elif filter_type == FILTER_WORD_TYPE.TOPIC_REPLY:
        words = FilterWord.objects.filter(is_filter=True, in_topic_reply=True).values_list('word', flat=True)

    elif filter_type == FILTER_WORD_TYPE.TOPIC_CHAT:
        words = FilterWord.objects.filter(is_filter=True, in_topic_chat=True).values_list('word', flat=True)

    return list(words)
