# coding=utf-8
import json
import logging
from statistic.models import DoctorRankFactor, HospitalRankFactor
from hippo.models.doctor import Doctor
from hippo.models.hospital import Hospital
from api.models.counsellor import (
        Consultant, CounsellorSmartRank,
        ConsultationCtDtStrategyFactor,
        CounsellorServiceSPU,
        GradeSmartRank)
# from django.conf import settings
from .transfer import get_area_tag_info
from search.utils.area import get_nearby_city_tag_ids
from rpc.tool.log_tool import logging_exception


def get_consultant(instance):
    d = instance
    id = ''.join(str(d.id).split('-'))
    res = {
        'id': id,
        'facevideo_is_onlie': True if d.status in (2, 3) else False,
        'facevideo_is_status': d.status,
        'facevideo_good_at_ids': len(json.loads(d.good_at)) if d.good_at else 0,
        'facevideo_is_assistant': d.is_assistant,
        'facevideo_good_at': json.loads(d.good_at) if d.good_at else [],
        'type': d.type,
        'is_banned': d.is_banned,
        'merchant_id': d.merchant_id,
        'doctor_id': d.doctor_id,
        'consultant_id': d.consultant_id,
        "user_id": d.user_id,
        'facevideo_rec_rank': d.facevideo_rec_rank,
        "facevideo_rank": d.facevideo_rank
    }

    res['doctor_score'] = 0
    city_id = 0
    hospital = None
    if res['type'] == 1:
        doctor = Doctor.objects.filter(id=d.doctor_id).first()
        if doctor:
            res['is_online'] = doctor.is_online
            hospital = Hospital.objects.filter(id=doctor.hospital_id).first()
            res['doctor_score'] = DoctorRankFactor.get_doctor_score(d.doctor_id)

    else:
        consultant = Consultant.objects.filter(id=d.consultant_id).first()
        res['is_online'] = consultant.is_online
        if consultant.hospital_id:
            hospital = Hospital.objects.filter(id=consultant.hospital_id).first()
            res['doctor_score'] = HospitalRankFactor.get_hospital_score(consultant.hospital_id, consultant.doctor_id)
        logging.info("get hospital:%s" % (hospital))

    # 医生关联的医院
    try:
        if hospital:
            city_id = hospital.city.id
            res['hospital'] = {
                'id': hospital.id,
                'name': hospital.name,
                'hospital_type': hospital.hospital_type,
            }
            # hospital position info
            if hospital.city:
                h = res['hospital']
                h['city_name'] = hospital.city.name
                h['city_province_name'] = hospital.city.province.name
                h.update(get_area_tag_info(hospital.city))
            if hospital.officer:
                h = res['hospital']
                h['officer_name'] = hospital.officer.name
    except:
        logging_exception()

    # 医生临近城市
    try:
        res['nearby_city_tag_ids'] = get_nearby_city_tag_ids(city_id=city_id)
    except (AttributeError, KeyError):
        res['nearby_city_tag_ids'] = []

    res['rank_score'] = DoctorRankFactor.get_rank_score(d.id)
    try:
        obj = CounsellorSmartRank.objects.filter(counsellor=d).first()
        consult_statistic = ConsultationCtDtStrategyFactor.objects.filter(
            counsellor_id=d.id.hex).order_by("-create_day").first()

        last_1v1_all_connect_rate_30d = consult_statistic.last_1v1_all_connect_rate_30d
        last_1v1_all_connect_EFFECTIVE_rate_30d = consult_statistic.last_1v1_all_connect_EFFECTIVE_rate_30d
        last_5_card_feed_ctr_30d = consult_statistic.last_5_card_feed_ctr_30d
        last_all_card_rate_30d = consult_statistic.last_all_card_rate_30d

        a1 = obj.recent_30_min_connected_rate / last_1v1_all_connect_rate_30d
        a2 = obj.recent_1_hour_connected_rate / last_1v1_all_connect_rate_30d
        a = obj.recent_3_hour_connected_rate / last_1v1_all_connect_rate_30d
        a3 = consult_statistic.last_1v1_connect_rate_1d / last_1v1_all_connect_rate_30d
        a4 = consult_statistic.last_1v1_connect_rate_7d / last_1v1_all_connect_rate_30d
        a5 = consult_statistic.last_1v1_connect_rate_30d / last_1v1_all_connect_rate_30d

        b1 = consult_statistic.last_1v1_connect_EFFECTIVE_rate_1d / last_1v1_all_connect_EFFECTIVE_rate_30d
        b2 = consult_statistic.last_1v1_connect_EFFECTIVE_rate_3d / last_1v1_all_connect_EFFECTIVE_rate_30d
        b3 = consult_statistic.last_1v1_connect_EFFECTIVE_rate_7d / last_1v1_all_connect_EFFECTIVE_rate_30d
        b4 = consult_statistic.last_1v1_connect_EFFECTIVE_rate_30d / last_1v1_all_connect_EFFECTIVE_rate_30d

        c1 = consult_statistic.last_card_feed_ctr_1d / last_5_card_feed_ctr_30d
        c2 = consult_statistic.last_card_feed_ctr_30d / last_5_card_feed_ctr_30d

        d1 = consult_statistic.last_card_rate_1d / last_all_card_rate_30d
        d2 = consult_statistic.last_card_rate_30d / last_all_card_rate_30d

        # 接通率，呼叫率，有效率，点击率，当前顾问总连线数， 是否<=5
        if obj.consult_records <= 5:
            counsellor_grade = CounsellorServiceSPU.objects.filter(counsellor=d).order_by('-created_time').first()
            try:
                grade = GradeSmartRank.objects.get(grade=counsellor_grade.counsellor_grade)
                recent_30_min_connected_rate = grade.recent_30_min_connected_rate
                recent_1_hour_connected_rate = grade.recent_1_hour_connected_rate
                recent_3_hour_connected_rate = grade.recent_3_hour_connected_rate
            except:
                recent_30_min_connected_rate = 0
                recent_1_hour_connected_rate = 0
                recent_3_hour_connected_rate = 0
            a = (recent_3_hour_connected_rate / last_1v1_all_connect_rate_30d) * 0.5
            a1 = (recent_30_min_connected_rate / last_1v1_all_connect_rate_30d) * 0.5
            a2 = (recent_1_hour_connected_rate / last_1v1_all_connect_rate_30d) * 0.5
            a3 = (consult_statistic.last_1v1_grant_connect_rate_1d / last_1v1_all_connect_rate_30d) * 0.5
            a4 = (consult_statistic.last_1v1_grant_connect_rate_7d / last_1v1_all_connect_rate_30d) * 0.5
            a5 = (consult_statistic.last_1v1_grant_connect_rate_30d / last_1v1_all_connect_rate_30d) * 0.5
            d1 = (consult_statistic.last_grade_card_rate_1d / last_all_card_rate_30d) * 0.5
            d2 = (consult_statistic.last_grade_card_rate_30d / last_all_card_rate_30d)

            b1 = (consult_statistic.last_1v1_grant_connect_EFFECTIVE_rate_1d / last_1v1_all_connect_EFFECTIVE_rate_30d) * 0.5
            b2 = (consult_statistic.last_1v1_grant_connect_EFFECTIVE_rate_3d / last_1v1_all_connect_EFFECTIVE_rate_30d) * 0.5
            b3 = (consult_statistic.last_1v1_grant_connect_EFFECTIVE_rate_7d / last_1v1_all_connect_EFFECTIVE_rate_30d) * 0.5
            b4 = (consult_statistic.last_1v1_grant_connect_EFFECTIVE_rate_30d / last_1v1_all_connect_EFFECTIVE_rate_30d) * 0.5

            c1 = (consult_statistic.last_grade_card_feed_ctr_1d / last_5_card_feed_ctr_30d) * 0.5
            c2 = (consult_statistic.last_grade_card_feed_ctr_30d / last_5_card_feed_ctr_30d) * 0.5

        res["consult_score"] = (a*16 + a1*16 + a2*16 + a3*16 + a4*8 + a5*4) + \
            (b1*8 + b2*8 + b3*4 + b4*2) + \
            (c1*8 + c2*4) + \
            (d1*16 + d2*8)

    except:
        logging_exception()
        res["consult_score"] = 0

    print(res)
    logging.info("get consultant:%s" % res)
    return res
